/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.channel.ContentSource;
import io.reactivex.netty.protocol.http.internal.HttpMessageFormatter;
import io.reactivex.netty.protocol.http.sse.ServerSentEvent;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Observable;

public abstract class HttpClientResponse<T> {
    public abstract HttpVersion getHttpVersion();

    public abstract HttpResponseStatus getStatus();

    public abstract Map<String, Set<Cookie>> getCookies();

    public abstract boolean containsHeader(CharSequence var1);

    public abstract boolean containsHeader(CharSequence var1, CharSequence var2, boolean var3);

    public abstract Iterator<Map.Entry<CharSequence, CharSequence>> headerIterator();

    public abstract String getHeader(CharSequence var1);

    public abstract String getHeader(CharSequence var1, String var2);

    public abstract List<String> getAllHeaderValues(CharSequence var1);

    public abstract long getContentLength();

    public abstract long getContentLength(long var1);

    public abstract long getDateHeader(CharSequence var1) throws ParseException;

    public abstract long getDateHeader(CharSequence var1, long var2);

    public abstract String getHostHeader();

    public abstract String getHost(String var1);

    public abstract int getIntHeader(CharSequence var1);

    public abstract int getIntHeader(CharSequence var1, int var2);

    public abstract boolean isContentLengthSet();

    public abstract boolean isKeepAlive();

    public abstract boolean isTransferEncodingChunked();

    public abstract Set<String> getHeaderNames();

    public abstract HttpClientResponse<T> addHeader(CharSequence var1, Object var2);

    public abstract HttpClientResponse<T> addCookie(Cookie var1);

    public abstract HttpClientResponse<T> addDateHeader(CharSequence var1, Date var2);

    public abstract HttpClientResponse<T> addDateHeader(CharSequence var1, Iterable<Date> var2);

    public abstract HttpClientResponse<T> addHeader(CharSequence var1, Iterable<Object> var2);

    public abstract HttpClientResponse<T> setDateHeader(CharSequence var1, Date var2);

    public abstract HttpClientResponse<T> setHeader(CharSequence var1, Object var2);

    public abstract HttpClientResponse<T> setDateHeader(CharSequence var1, Iterable<Date> var2);

    public abstract HttpClientResponse<T> setHeader(CharSequence var1, Iterable<Object> var2);

    public abstract HttpClientResponse<T> removeHeader(CharSequence var1);

    public abstract ContentSource<ServerSentEvent> getContentAsServerSentEvents();

    public abstract ContentSource<T> getContent();

    public abstract Observable<Void> discardContent();

    public abstract <TT> HttpClientResponse<TT> transformContent(Observable.Transformer<T, TT> var1);

    public abstract Channel unsafeNettyChannel();

    public abstract Connection<?, ?> unsafeConnection();

    public String toString() {
        return HttpMessageFormatter.formatResponse(this.getHttpVersion(), this.getStatus(), this.headerIterator());
    }
}

