/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client.internal;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.internal.VoidToAnythingCast;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.HttpRedirectException;
import io.reactivex.netty.protocol.http.client.internal.HttpClientRequestImpl;
import io.reactivex.netty.protocol.http.client.internal.RawRequest;
import io.reactivex.netty.protocol.tcp.client.TcpClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;

public class Redirector<I, O>
implements Func1<HttpClientResponse<O>, Observable<HttpClientResponse<O>>> {
    public static final int DEFAULT_MAX_REDIRECTS = 5;
    private static final Logger logger = LoggerFactory.getLogger(Redirector.class);
    private static final int[] REDIRECTABLE_STATUS_CODES = new int[]{301, 302, 303, 307, 308};
    private final List<String> visitedLocations;
    private final int maxHops;
    private final AtomicInteger redirectCount;
    private volatile HttpResponseStatus lastRedirectStatus;
    private final TcpClient<?, HttpClientResponse<O>> client;
    private RawRequest<I, O> originalRequest;

    public Redirector(int maxHops, TcpClient<?, HttpClientResponse<O>> client) {
        this.maxHops = maxHops;
        this.client = client;
        this.visitedLocations = new ArrayList<String>();
        this.redirectCount = new AtomicInteger();
    }

    public Redirector(TcpClient<?, HttpClientResponse<O>> client) {
        this(5, client);
    }

    public void setOriginalRequest(RawRequest<I, O> originalRequest) {
        if (null != this.originalRequest) {
            throw new IllegalStateException("Original request is already set.");
        }
        this.originalRequest = originalRequest;
        this.visitedLocations.add(originalRequest.getHeaders().uri());
    }

    public Observable<HttpClientResponse<O>> call(HttpClientResponse<O> response) {
        HttpClientRequest<I, O> toReturn;
        if (null == this.originalRequest) {
            toReturn = Observable.error((Throwable)new IllegalStateException("Raw request not available to the redirector."));
        } else if (this.requiresRedirect(response)) {
            String location = this.extractRedirectLocation(response);
            if (location == null) {
                toReturn = Observable.error((Throwable)new HttpRedirectException(HttpRedirectException.Reason.InvalidRedirect, "No redirect location found."));
            } else if (this.visitedLocations.contains(location)) {
                toReturn = Observable.error((Throwable)new HttpRedirectException(HttpRedirectException.Reason.RedirectLoop, "Redirection contains a loop. Last requested location: " + location));
            } else if (this.redirectCount.get() >= this.maxHops) {
                toReturn = Observable.error((Throwable)new HttpRedirectException(HttpRedirectException.Reason.TooManyRedirects, "Too many redirects. Max redirects: " + this.maxHops));
            } else {
                try {
                    URI redirectUri = new URI(location);
                    this.lastRedirectStatus = response.getStatus();
                    this.redirectCount.incrementAndGet();
                    toReturn = this.createRedirectRequest(this.originalRequest, redirectUri, this.lastRedirectStatus.code());
                }
                catch (Exception e) {
                    toReturn = Observable.error((Throwable)new HttpRedirectException(HttpRedirectException.Reason.InvalidRedirect, "Location is not a valid URI. Provided location: " + location, e));
                }
            }
        } else {
            return Observable.just(response);
        }
        return response.discardContent().map((Func1)new VoidToAnythingCast()).ignoreElements().concatWith((Observable)toReturn);
    }

    public boolean requiresRedirect(HttpClientResponse<O> response) {
        int statusCode = response.getStatus().code();
        boolean requiresRedirect = false;
        if (Arrays.binarySearch(REDIRECTABLE_STATUS_CODES, statusCode) >= 0) {
            String location = this.extractRedirectLocation(response);
            boolean bl = requiresRedirect = null == location || !location.startsWith("http");
        }
        if (requiresRedirect && statusCode != HttpResponseStatus.SEE_OTHER.code()) {
            HttpMethod originalMethod = this.originalRequest.getHeaders().method();
            requiresRedirect = originalMethod == HttpMethod.GET || originalMethod == HttpMethod.HEAD;
        }
        return requiresRedirect;
    }

    protected String extractRedirectLocation(HttpClientResponse<O> redirectedResponse) {
        return redirectedResponse.getHeader((CharSequence)HttpHeaderNames.LOCATION);
    }

    protected HttpClientRequest<I, O> createRedirectRequest(RawRequest<I, O> original, URI redirectLocation, int redirectStatus) {
        String redirectUri = Redirector.getNettyRequestUri(redirectLocation, original.getHeaders().uri(), redirectStatus);
        RawRequest<I, O> redirectRequest = original.setUri(redirectUri);
        if (redirectStatus == 303) {
            redirectRequest = RawRequest.create(redirectRequest.getHeaders().protocolVersion(), HttpMethod.GET, redirectUri, this);
        }
        return HttpClientRequestImpl.create(redirectRequest, this.client);
    }

    protected static String getNettyRequestUri(URI uri, String originalUriString, int redirectStatus) {
        StringBuilder sb = new StringBuilder();
        if (uri.getRawPath() != null) {
            sb.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            sb.append('?').append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            sb.append('#').append(uri.getRawFragment());
        } else if (redirectStatus >= 300) {
            try {
                URI originalUri = new URI(originalUriString);
                if (originalUri.getRawFragment() != null) {
                    sb.append('#').append(originalUri.getRawFragment());
                }
            }
            catch (URISyntaxException e) {
                logger.warn("Error parsing original request URI during redirect. This means that the path fragment if any in the original request will not be inherited by the redirect.", (Throwable)e);
            }
        }
        return sb.toString();
    }

    static {
        Arrays.sort(REDIRECTABLE_STATUS_CODES);
    }
}

