/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.ReferenceCountUtil;
import io.reactivex.netty.channel.ContentSource;
import io.reactivex.netty.protocol.http.CookiesHolder;
import io.reactivex.netty.protocol.http.internal.HttpContentSubscriberEvent;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.UriInfoHolder;
import io.reactivex.netty.protocol.http.ws.server.WebSocketHandshaker;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

class HttpServerRequestImpl<T>
extends HttpServerRequest<T> {
    private final Channel nettyChannel;
    private final HttpRequest nettyRequest;
    private final CookiesHolder cookiesHolder;
    private final UriInfoHolder uriInfoHolder;
    private final ContentSource<T> contentSource;

    HttpServerRequestImpl(HttpRequest nettyRequest, Channel nettyChannel) {
        this.nettyRequest = nettyRequest;
        this.nettyChannel = nettyChannel;
        this.uriInfoHolder = new UriInfoHolder(this.nettyRequest.uri());
        this.cookiesHolder = CookiesHolder.newServerRequestHolder(nettyRequest.headers());
        this.contentSource = new ContentSource(nettyChannel, new Func1<Subscriber<? super T>, Object>(){

            public Object call(Subscriber<? super T> subscriber) {
                return new HttpContentSubscriberEvent(subscriber);
            }
        });
    }

    private HttpServerRequestImpl(HttpRequest nettyRequest, Channel nettyChannel, ContentSource<T> contentSource) {
        this.nettyRequest = nettyRequest;
        this.nettyChannel = nettyChannel;
        this.uriInfoHolder = new UriInfoHolder(this.nettyRequest.uri());
        this.cookiesHolder = CookiesHolder.newServerRequestHolder(nettyRequest.headers());
        this.contentSource = contentSource;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.nettyRequest.method();
    }

    @Override
    public HttpVersion getHttpVersion() {
        return this.nettyRequest.protocolVersion();
    }

    @Override
    public String getUri() {
        return this.uriInfoHolder.getRawUriString();
    }

    @Override
    public String getDecodedPath() {
        return this.uriInfoHolder.getPath();
    }

    @Override
    public String getRawQueryString() {
        return this.uriInfoHolder.getQueryString();
    }

    @Override
    public Map<String, Set<Cookie>> getCookies() {
        return this.cookiesHolder.getAllCookies();
    }

    @Override
    public Map<String, List<String>> getQueryParameters() {
        return this.uriInfoHolder.getQueryParameters();
    }

    @Override
    public boolean containsHeader(CharSequence name) {
        return this.nettyRequest.headers().contains(name);
    }

    @Override
    public boolean containsHeader(CharSequence name, CharSequence value, boolean ignoreCaseValue) {
        return this.nettyRequest.headers().contains(name, value, ignoreCaseValue);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> headerIterator() {
        return this.nettyRequest.headers().iteratorCharSequence();
    }

    @Override
    public String getHeader(CharSequence name) {
        return this.nettyRequest.headers().get(name);
    }

    @Override
    public String getHeader(CharSequence name, String defaultValue) {
        return this.nettyRequest.headers().get(name, defaultValue);
    }

    @Override
    public List<String> getAllHeaderValues(CharSequence name) {
        return this.nettyRequest.headers().getAll(name);
    }

    @Override
    public long getContentLength() {
        return HttpUtil.getContentLength((HttpMessage)this.nettyRequest);
    }

    @Override
    public long getContentLength(long defaultValue) {
        return HttpUtil.getContentLength((HttpMessage)this.nettyRequest, (long)defaultValue);
    }

    @Override
    public long getDateHeader(CharSequence name) {
        return this.nettyRequest.headers().getTimeMillis(name);
    }

    @Override
    public long getDateHeader(CharSequence name, long defaultValue) {
        return this.nettyRequest.headers().getTimeMillis(name, defaultValue);
    }

    @Override
    public String getHostHeader() {
        return this.nettyRequest.headers().get((CharSequence)HttpHeaderNames.HOST);
    }

    @Override
    public String getHostHeader(String defaultValue) {
        return this.nettyRequest.headers().get((CharSequence)HttpHeaderNames.HOST, defaultValue);
    }

    @Override
    public int getIntHeader(CharSequence name) {
        return this.nettyRequest.headers().getInt(name);
    }

    @Override
    public int getIntHeader(CharSequence name, int defaultValue) {
        return this.nettyRequest.headers().getInt(name, defaultValue);
    }

    @Override
    public boolean is100ContinueExpected() {
        return HttpUtil.is100ContinueExpected((HttpMessage)this.nettyRequest);
    }

    @Override
    public boolean isContentLengthSet() {
        return HttpUtil.isContentLengthSet((HttpMessage)this.nettyRequest);
    }

    @Override
    public boolean isKeepAlive() {
        return HttpUtil.isKeepAlive((HttpMessage)this.nettyRequest);
    }

    @Override
    public boolean isTransferEncodingChunked() {
        return HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyRequest);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.nettyRequest.headers().names();
    }

    @Override
    public HttpServerRequest<T> addHeader(CharSequence name, Object value) {
        this.nettyRequest.headers().add(name, value);
        return this;
    }

    @Override
    public HttpServerRequest<T> addCookie(Cookie cookie) {
        this.nettyRequest.headers().add((CharSequence)HttpHeaderNames.COOKIE, (Object)ClientCookieEncoder.STRICT.encode(cookie));
        return this;
    }

    @Override
    public HttpServerRequest<T> addDateHeader(CharSequence name, Date value) {
        this.nettyRequest.headers().add(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerRequest<T> addDateHeader(CharSequence name, Iterable<Date> values) {
        for (Date value : values) {
            this.nettyRequest.headers().add(name, (Object)value);
        }
        return this;
    }

    @Override
    public HttpServerRequest<T> addHeader(CharSequence name, Iterable<Object> values) {
        this.nettyRequest.headers().add(name, values);
        return this;
    }

    @Override
    public HttpServerRequest<T> setDateHeader(CharSequence name, Date value) {
        this.nettyRequest.headers().set(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerRequest<T> setHeader(CharSequence name, Object value) {
        this.nettyRequest.headers().set(name, value);
        return this;
    }

    @Override
    public HttpServerRequest<T> setDateHeader(CharSequence name, Iterable<Date> values) {
        for (Date value : values) {
            this.nettyRequest.headers().set(name, (Object)value);
        }
        return this;
    }

    @Override
    public HttpServerRequest<T> setHeader(CharSequence name, Iterable<Object> values) {
        this.nettyRequest.headers().add(name, values);
        return this;
    }

    @Override
    public HttpServerRequest<T> removeHeader(CharSequence name) {
        this.nettyRequest.headers().remove(name);
        return this;
    }

    @Override
    public ContentSource<T> getContent() {
        return this.contentSource;
    }

    @Override
    public Observable<Void> discardContent() {
        return this.getContent().map(new Func1<T, Void>(){

            public Void call(T t) {
                ReferenceCountUtil.release(t);
                return null;
            }
        }).ignoreElements();
    }

    @Override
    public Observable<Void> dispose() {
        return this.discardContent().onErrorResumeNext(Observable.empty());
    }

    @Override
    public boolean isWebSocketUpgradeRequested() {
        return WebSocketHandshaker.isUpgradeRequested(this);
    }

    @Override
    public <X> HttpServerRequest<X> transformContent(Observable.Transformer<T, X> transformer) {
        return new HttpServerRequestImpl<T>(this.nettyRequest, this.nettyChannel, this.contentSource.transform(transformer));
    }

    @Override
    DecoderResult decoderResult() {
        return this.nettyRequest.decoderResult();
    }
}

