/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.sse;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSentEvent
implements ByteBufHolder {
    private static final Logger logger = LoggerFactory.getLogger(ServerSentEvent.class);
    private static Charset sseEncodingCharset;
    private final Type type;
    private final String dataAsString;
    private final ByteBuf data;
    private final ByteBuf eventId;
    private final ByteBuf eventType;

    public ServerSentEvent(Type type, ByteBuf data) {
        this(type, null, null, data);
    }

    public ServerSentEvent(ByteBuf data) {
        this(Type.Data, data);
    }

    public ServerSentEvent(ByteBuf eventId, ByteBuf eventType, ByteBuf data) {
        this(Type.Data, eventId, eventType, data);
    }

    protected ServerSentEvent(Type type, ByteBuf eventId, ByteBuf eventType, ByteBuf data) {
        this.dataAsString = null;
        this.data = data;
        this.type = type;
        this.eventId = eventId;
        this.eventType = eventType;
    }

    private ServerSentEvent(String data) {
        this.dataAsString = data;
        this.data = null;
        this.type = Type.Data;
        this.eventId = null;
        this.eventType = null;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasEventId() {
        return null != this.eventId;
    }

    public boolean hasEventType() {
        return null != this.eventType;
    }

    public ByteBuf getEventId() {
        return this.eventId;
    }

    public String getEventIdAsString() {
        return this.eventId.toString(this.getSseCharset());
    }

    public ByteBuf getEventType() {
        return this.eventType;
    }

    public String getEventTypeAsString() {
        return this.eventType.toString(this.getSseCharset());
    }

    public boolean hasDataAsString() {
        return null != this.dataAsString;
    }

    public String contentAsString() {
        return null != this.dataAsString ? this.dataAsString : this.data.toString(this.getSseCharset());
    }

    public ByteBuf content() {
        return null != this.data ? this.data : Unpooled.buffer().writeBytes(this.dataAsString.getBytes(this.getSseCharset()));
    }

    public ByteBufHolder copy() {
        if (this.hasDataAsString()) {
            return new ServerSentEvent(this.dataAsString);
        }
        return new ServerSentEvent(this.type, null != this.eventId ? this.eventId.copy() : null, null != this.eventType ? this.eventType.copy() : null, this.data.copy());
    }

    public ByteBufHolder duplicate() {
        if (this.hasDataAsString()) {
            return new ServerSentEvent(this.dataAsString);
        }
        return new ServerSentEvent(this.type, null != this.eventId ? this.eventId.duplicate() : null, null != this.eventType ? this.eventType.duplicate() : null, this.data.duplicate());
    }

    public int refCnt() {
        return this.hasDataAsString() ? 1 : this.data.refCnt();
    }

    public ByteBufHolder retain() {
        if (this.hasEventId()) {
            this.eventId.retain();
        }
        if (this.hasEventType()) {
            this.eventType.retain();
        }
        if (!this.hasDataAsString()) {
            this.data.retain();
        }
        return this;
    }

    public ByteBufHolder retain(int increment) {
        if (this.hasEventId()) {
            this.eventId.retain(increment);
        }
        if (this.hasEventType()) {
            this.eventType.retain(increment);
        }
        if (!this.hasDataAsString()) {
            this.data.retain(increment);
        }
        return this;
    }

    public ByteBufHolder touch() {
        return this.touch(null);
    }

    public ByteBufHolder touch(Object hint) {
        if (!this.hasDataAsString()) {
            this.data.touch(hint);
        }
        return this;
    }

    public boolean release() {
        return this.data.release(1);
    }

    public boolean release(int decrement) {
        if (this.hasEventId()) {
            this.eventId.release(decrement);
        }
        if (this.hasEventType()) {
            this.eventType.release(decrement);
        }
        return this.data.release(decrement);
    }

    public static ServerSentEvent withEventId(ByteBuf eventId, ByteBuf data) {
        return new ServerSentEvent(eventId, null, data);
    }

    public static ServerSentEvent withEventType(ByteBuf eventType, ByteBuf data) {
        return new ServerSentEvent(null, eventType, data);
    }

    public static ServerSentEvent withEventIdAndType(ByteBuf eventId, ByteBuf eventType, ByteBuf data) {
        return new ServerSentEvent(eventId, eventType, data);
    }

    public static ServerSentEvent withData(ByteBuf data) {
        return new ServerSentEvent(data);
    }

    public static ServerSentEvent withData(String data) {
        return new ServerSentEvent(data);
    }

    protected Charset getSseCharset() {
        return null == sseEncodingCharset ? Charset.forName("UTF-8") : sseEncodingCharset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasEventId()) {
            sb.append("id: ");
            sb.append(this.getEventIdAsString());
            sb.append('\n');
        }
        if (this.hasEventType()) {
            sb.append("event: ");
            sb.append(this.getEventTypeAsString());
            sb.append('\n');
        }
        sb.append("data: ");
        sb.append(this.contentAsString());
        sb.append('\n');
        return sb.toString();
    }

    static {
        try {
            sseEncodingCharset = Charset.forName("UTF-8");
        }
        catch (Exception e) {
            logger.error("UTF-8 charset not available. Since SSE only contains UTF-8 data, we can not read SSE data.");
            sseEncodingCharset = null;
        }
    }

    public static enum Type {
        Data,
        Id,
        EventType;

    }
}

