/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.api;

import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.enterprise.util.Nonbinding;
import jakarta.interceptor.InterceptorBinding;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@InterceptorBinding
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
public @interface CurrentThreadContext {
    @Nonbinding
    public boolean remove() default false;

    @Nonbinding
    public String[] cleared() default {};

    @Nonbinding
    public String[] propagated() default {"Remaining"};

    @Nonbinding
    public String[] unchanged() default {};

    public static final class Literal
    extends AnnotationLiteral<CurrentThreadContext>
    implements CurrentThreadContext {
        public static final Literal DEFAULT_INSTANCE = Literal.of(false, new String[0], new String[0], new String[]{"Remaining"});
        private static final long serialVersionUID = 1L;
        private final boolean remove;
        private final String[] cleared;
        private final String[] unchanged;
        private final String[] propagated;

        private Literal(boolean remove, String[] cleared, String[] unchanged, String[] propagated) {
            this.remove = remove;
            this.cleared = cleared;
            this.unchanged = unchanged;
            this.propagated = propagated;
        }

        public static Literal of(boolean remove, String[] cleared, String[] unchanged, String[] propagated) {
            return new Literal(remove, cleared, unchanged, propagated);
        }

        @Override
        public boolean remove() {
            return this.remove;
        }

        @Override
        public String[] cleared() {
            return this.cleared;
        }

        @Override
        public String[] unchanged() {
            return this.unchanged;
        }

        @Override
        public String[] propagated() {
            return this.propagated;
        }
    }
}

