/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.models.ExternalDocs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodegenOperation {
    public final List<CodegenProperty> responseHeaders = new ArrayList<CodegenProperty>();
    public boolean hasAuthMethods;
    public boolean hasConsumes;
    public boolean hasProduces;
    public boolean hasParams;
    public boolean hasOptionalParams;
    public boolean returnTypeIsPrimitive;
    public boolean returnSimpleType;
    public boolean subresourceOperation;
    public boolean isMapContainer;
    public boolean isListContainer;
    public boolean isMultipart;
    public boolean hasMore = true;
    public boolean isResponseBinary = false;
    public boolean isResponseFile = false;
    public boolean hasReference = false;
    public boolean isRestfulIndex;
    public boolean isRestfulShow;
    public boolean isRestfulCreate;
    public boolean isRestfulUpdate;
    public boolean isRestfulDestroy;
    public boolean isRestful;
    public String path;
    public String operationId;
    public String returnType;
    public String httpMethod;
    public String returnBaseType;
    public String returnContainer;
    public String summary;
    public String unescapedNotes;
    public String notes;
    public String baseName;
    public String defaultResponse;
    public String discriminator;
    public List<Map<String, String>> consumes;
    public List<Map<String, String>> produces;
    public List<Map<String, String>> prioritizedContentTypes;
    public CodegenParameter bodyParam;
    public List<CodegenParameter> allParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> formParams = new ArrayList<CodegenParameter>();
    public List<CodegenSecurity> authMethods;
    public List<String> tags;
    public List<CodegenResponse> responses = new ArrayList<CodegenResponse>();
    public Set<String> imports = new HashSet<String>();
    public List<Map<String, String>> examples;
    public ExternalDocs externalDocs;
    public Map<String, Object> vendorExtensions;
    public String nickname;
    public String operationIdLowerCase;
    public String operationIdCamelCase;
    public String operationIdSnakeCase;

    private static boolean nonempty(List<?> params) {
        return params != null && params.size() > 0;
    }

    public boolean getHasBodyParam() {
        return CodegenOperation.nonempty(this.bodyParams);
    }

    public boolean getHasQueryParams() {
        return CodegenOperation.nonempty(this.queryParams);
    }

    public boolean getHasHeaderParams() {
        return CodegenOperation.nonempty(this.headerParams);
    }

    public boolean getHasPathParams() {
        return CodegenOperation.nonempty(this.pathParams);
    }

    public boolean getHasFormParams() {
        return CodegenOperation.nonempty(this.formParams);
    }

    public boolean getHasExamples() {
        return CodegenOperation.nonempty(this.examples);
    }

    public boolean isRestfulIndex() {
        return "GET".equals(this.httpMethod) && "".equals(this.pathWithoutBaseName());
    }

    public boolean isRestfulShow() {
        return "GET".equalsIgnoreCase(this.httpMethod) && this.isMemberPath();
    }

    public boolean isRestfulCreate() {
        return "POST".equalsIgnoreCase(this.httpMethod) && "".equals(this.pathWithoutBaseName());
    }

    public boolean isRestfulUpdate() {
        return Arrays.asList("PUT", "PATCH").contains(this.httpMethod.toUpperCase()) && this.isMemberPath();
    }

    public boolean isRestfulDestroy() {
        return "DELETE".equalsIgnoreCase(this.httpMethod) && this.isMemberPath();
    }

    public boolean isRestful() {
        return this.isRestfulIndex() || this.isRestfulShow() || this.isRestfulCreate() || this.isRestfulUpdate() || this.isRestfulDestroy();
    }

    private String pathWithoutBaseName() {
        return this.baseName != null ? this.path.replace("/" + this.baseName.toLowerCase(), "") : this.path;
    }

    private boolean isMemberPath() {
        if (this.pathParams.size() != 1) {
            return false;
        }
        String id = this.pathParams.get((int)0).baseName;
        return ("/{" + id + "}").equals(this.pathWithoutBaseName());
    }

    public String toString() {
        return String.format("%s(%s)", this.baseName, this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodegenOperation that = (CodegenOperation)o;
        if (this.responseHeaders != null ? !this.responseHeaders.equals(that.responseHeaders) : that.responseHeaders != null) {
            return false;
        }
        if (this.hasAuthMethods != that.hasAuthMethods) {
            return false;
        }
        if (this.hasConsumes != that.hasConsumes) {
            return false;
        }
        if (this.hasProduces != that.hasProduces) {
            return false;
        }
        if (this.hasParams != that.hasParams) {
            return false;
        }
        if (this.hasOptionalParams != that.hasOptionalParams) {
            return false;
        }
        if (this.returnTypeIsPrimitive != that.returnTypeIsPrimitive) {
            return false;
        }
        if (this.returnSimpleType != that.returnSimpleType) {
            return false;
        }
        if (this.subresourceOperation != that.subresourceOperation) {
            return false;
        }
        if (this.isMapContainer != that.isMapContainer) {
            return false;
        }
        if (this.isListContainer != that.isListContainer) {
            return false;
        }
        if (this.isMultipart != that.isMultipart) {
            return false;
        }
        if (this.hasMore != that.hasMore) {
            return false;
        }
        if (this.isResponseBinary != that.isResponseBinary) {
            return false;
        }
        if (this.hasReference != that.hasReference) {
            return false;
        }
        if (this.isResponseFile != that.isResponseFile) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.operationId != null ? !this.operationId.equals(that.operationId) : that.operationId != null) {
            return false;
        }
        if (this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null) {
            return false;
        }
        if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) {
            return false;
        }
        if (this.returnBaseType != null ? !this.returnBaseType.equals(that.returnBaseType) : that.returnBaseType != null) {
            return false;
        }
        if (this.returnContainer != null ? !this.returnContainer.equals(that.returnContainer) : that.returnContainer != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(that.summary) : that.summary != null) {
            return false;
        }
        if (this.unescapedNotes != null ? !this.unescapedNotes.equals(that.unescapedNotes) : that.unescapedNotes != null) {
            return false;
        }
        if (this.notes != null ? !this.notes.equals(that.notes) : that.notes != null) {
            return false;
        }
        if (this.baseName != null ? !this.baseName.equals(that.baseName) : that.baseName != null) {
            return false;
        }
        if (this.defaultResponse != null ? !this.defaultResponse.equals(that.defaultResponse) : that.defaultResponse != null) {
            return false;
        }
        if (this.discriminator != null ? !this.discriminator.equals(that.discriminator) : that.discriminator != null) {
            return false;
        }
        if (this.consumes != null ? !this.consumes.equals(that.consumes) : that.consumes != null) {
            return false;
        }
        if (this.produces != null ? !this.produces.equals(that.produces) : that.produces != null) {
            return false;
        }
        if (this.bodyParam != null ? !this.bodyParam.equals(that.bodyParam) : that.bodyParam != null) {
            return false;
        }
        if (this.allParams != null ? !this.allParams.equals(that.allParams) : that.allParams != null) {
            return false;
        }
        if (this.bodyParams != null ? !this.bodyParams.equals(that.bodyParams) : that.bodyParams != null) {
            return false;
        }
        if (this.pathParams != null ? !this.pathParams.equals(that.pathParams) : that.pathParams != null) {
            return false;
        }
        if (this.queryParams != null ? !this.queryParams.equals(that.queryParams) : that.queryParams != null) {
            return false;
        }
        if (this.headerParams != null ? !this.headerParams.equals(that.headerParams) : that.headerParams != null) {
            return false;
        }
        if (this.formParams != null ? !this.formParams.equals(that.formParams) : that.formParams != null) {
            return false;
        }
        if (this.authMethods != null ? !this.authMethods.equals(that.authMethods) : that.authMethods != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.responses != null ? !this.responses.equals(that.responses) : that.responses != null) {
            return false;
        }
        if (this.imports != null ? !this.imports.equals(that.imports) : that.imports != null) {
            return false;
        }
        if (this.examples != null ? !this.examples.equals(that.examples) : that.examples != null) {
            return false;
        }
        if (this.externalDocs != null ? !this.externalDocs.equals((Object)that.externalDocs) : that.externalDocs != null) {
            return false;
        }
        if (this.vendorExtensions != null ? !this.vendorExtensions.equals(that.vendorExtensions) : that.vendorExtensions != null) {
            return false;
        }
        if (this.nickname != null ? !this.nickname.equals(that.nickname) : that.nickname != null) {
            return false;
        }
        if (this.prioritizedContentTypes != null ? !this.prioritizedContentTypes.equals(that.prioritizedContentTypes) : that.prioritizedContentTypes != null) {
            return false;
        }
        if (this.operationIdLowerCase != null ? !this.operationIdLowerCase.equals(that.operationIdLowerCase) : that.operationIdLowerCase != null) {
            return false;
        }
        return this.operationIdCamelCase != null ? this.operationIdCamelCase.equals(that.operationIdCamelCase) : that.operationIdCamelCase == null;
    }

    public int hashCode() {
        int result = this.responseHeaders.hashCode();
        result = 31 * result + (this.hasAuthMethods ? 13 : 31);
        result = 31 * result + (this.hasConsumes ? 13 : 31);
        result = 31 * result + (this.hasProduces ? 13 : 31);
        result = 31 * result + (this.hasParams ? 13 : 31);
        result = 31 * result + (this.hasOptionalParams ? 13 : 31);
        result = 31 * result + (this.returnTypeIsPrimitive ? 13 : 31);
        result = 31 * result + (this.returnSimpleType ? 13 : 31);
        result = 31 * result + (this.subresourceOperation ? 13 : 31);
        result = 31 * result + (this.isMapContainer ? 13 : 31);
        result = 31 * result + (this.isListContainer ? 13 : 31);
        result = 31 * result + (this.isMultipart ? 13 : 31);
        result = 31 * result + (this.hasMore ? 13 : 31);
        result = 31 * result + (this.isResponseBinary ? 13 : 31);
        result = 31 * result + (this.isResponseFile ? 13 : 31);
        result = 31 * result + (this.hasReference ? 13 : 31);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.operationId != null ? this.operationId.hashCode() : 0);
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
        result = 31 * result + (this.returnBaseType != null ? this.returnBaseType.hashCode() : 0);
        result = 31 * result + (this.returnContainer != null ? this.returnContainer.hashCode() : 0);
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.unescapedNotes != null ? this.unescapedNotes.hashCode() : 0);
        result = 31 * result + (this.notes != null ? this.notes.hashCode() : 0);
        result = 31 * result + (this.baseName != null ? this.baseName.hashCode() : 0);
        result = 31 * result + (this.defaultResponse != null ? this.defaultResponse.hashCode() : 0);
        result = 31 * result + (this.discriminator != null ? this.discriminator.hashCode() : 0);
        result = 31 * result + (this.consumes != null ? this.consumes.hashCode() : 0);
        result = 31 * result + (this.produces != null ? this.produces.hashCode() : 0);
        result = 31 * result + (this.bodyParam != null ? this.bodyParam.hashCode() : 0);
        result = 31 * result + (this.allParams != null ? this.allParams.hashCode() : 0);
        result = 31 * result + (this.bodyParams != null ? this.bodyParams.hashCode() : 0);
        result = 31 * result + (this.pathParams != null ? this.pathParams.hashCode() : 0);
        result = 31 * result + (this.queryParams != null ? this.queryParams.hashCode() : 0);
        result = 31 * result + (this.headerParams != null ? this.headerParams.hashCode() : 0);
        result = 31 * result + (this.formParams != null ? this.formParams.hashCode() : 0);
        result = 31 * result + (this.authMethods != null ? this.authMethods.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.responses != null ? this.responses.hashCode() : 0);
        result = 31 * result + (this.imports != null ? this.imports.hashCode() : 0);
        result = 31 * result + (this.examples != null ? this.examples.hashCode() : 0);
        result = 31 * result + (this.externalDocs != null ? this.externalDocs.hashCode() : 0);
        result = 31 * result + (this.vendorExtensions != null ? this.vendorExtensions.hashCode() : 0);
        result = 31 * result + (this.nickname != null ? this.nickname.hashCode() : 0);
        result = 31 * result + (this.prioritizedContentTypes != null ? this.prioritizedContentTypes.hashCode() : 0);
        result = 31 * result + (this.operationIdLowerCase != null ? this.operationIdLowerCase.hashCode() : 0);
        result = 31 * result + (this.operationIdCamelCase != null ? this.operationIdCamelCase.hashCode() : 0);
        return result;
    }
}

