/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;

public class BashClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String apiVersion = "1.0.0";
    protected String curlOptions;
    protected boolean processMarkdown = false;
    protected String scriptName = "client.sh";
    protected boolean generateBashCompletion = false;
    protected boolean generateZshCompletion = false;
    protected String hostEnvironmentVariable;
    protected String basicAuthEnvironmentVariable;
    protected String apiKeyAuthEnvironmentVariable;
    public static final String CURL_OPTIONS = "curlOptions";
    public static final String PROCESS_MARKDOWN = "processMarkdown";
    public static final String SCRIPT_NAME = "scriptName";
    public static final String GENERATE_BASH_COMPLETION = "generateBashCompletion";
    public static final String GENERATE_ZSH_COMPLETION = "generateZshCompletion";
    public static final String HOST_ENVIRONMENT_VARIABLE_NAME = "hostEnvironmentVariable";
    public static final String BASIC_AUTH_ENVIRONMENT_VARIABLE_NAME = "basicAuthEnvironmentVariable";
    public static final String APIKEY_AUTH_ENVIRONMENT_VARIABLE_NAME = "apiKeyAuthEnvironmentVariable";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "bash";
    }

    @Override
    public String getHelp() {
        return "Generates a Bash client script based on cURL.";
    }

    public BashClientCodegen() {
        this.outputFolder = "generated-code/bash";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.clear();
        this.templateDir = "bash";
        this.embeddedTemplateDir = "bash";
        this.cliOptions.add(CliOption.newString(CURL_OPTIONS, "Default cURL options"));
        this.cliOptions.add(CliOption.newBoolean(PROCESS_MARKDOWN, "Convert all Markdown Markup into terminal formatting"));
        this.cliOptions.add(CliOption.newString(SCRIPT_NAME, "The name of the script that will be generated (e.g. petstore-cli)"));
        this.cliOptions.add(CliOption.newBoolean(GENERATE_BASH_COMPLETION, "Whether to generate the Bash completion script"));
        this.cliOptions.add(CliOption.newBoolean(GENERATE_ZSH_COMPLETION, "Whether to generate the Zsh completion script"));
        this.cliOptions.add(CliOption.newString(HOST_ENVIRONMENT_VARIABLE_NAME, "Name of environment variable where host can be defined (e.g. PETSTORE_HOST='http://petstore.swagger.io:8080')"));
        this.cliOptions.add(CliOption.newString(BASIC_AUTH_ENVIRONMENT_VARIABLE_NAME, "Name of environment variable where username and password can be defined (e.g. PETSTORE_CREDS='username:password')"));
        this.cliOptions.add(CliOption.newBoolean(APIKEY_AUTH_ENVIRONMENT_VARIABLE_NAME, "Name of environment variable where API key can be defined (e.g. PETSTORE_APIKEY='kjhasdGASDa5asdASD')"));
        this.reservedWords = new HashSet<String>(Arrays.asList("case", "do", "done", "elif", "else", "esac", "fi", "for", "function", "if", "in", "select", "then", "time", "until", "while"));
        this.typeMapping.clear();
        this.typeMapping.put("array", "array");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("List", "array");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("int", "integer");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "integer");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("long", "integer");
        this.typeMapping.put("short", "integer");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("object", "map");
        this.typeMapping.put("integer", "integer");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("binary", "binary");
        this.typeMapping.put("UUID", "string");
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.languageSpecificPrimitives = new HashSet();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CURL_OPTIONS)) {
            this.setCurlOptions(this.additionalProperties.get(CURL_OPTIONS).toString());
            this.additionalProperties.put("x-codegen-curl-options", this.curlOptions);
        }
        if (this.additionalProperties.containsKey(PROCESS_MARKDOWN)) {
            this.setProcessMarkdown(this.convertPropertyToBooleanAndWriteBack(PROCESS_MARKDOWN));
        }
        if (this.additionalProperties.containsKey(GENERATE_BASH_COMPLETION)) {
            this.setGenerateBashCompletion(this.convertPropertyToBooleanAndWriteBack(GENERATE_BASH_COMPLETION));
        }
        if (this.additionalProperties.containsKey(GENERATE_ZSH_COMPLETION)) {
            this.setGenerateZshCompletion(this.convertPropertyToBooleanAndWriteBack(GENERATE_ZSH_COMPLETION));
        }
        if (this.additionalProperties.containsKey(SCRIPT_NAME)) {
            this.setScriptName(this.additionalProperties.get(SCRIPT_NAME).toString());
        }
        this.additionalProperties.put("x-codegen-script-name", this.scriptName);
        if (this.additionalProperties.containsKey(HOST_ENVIRONMENT_VARIABLE_NAME)) {
            this.setHostEnvironmentVariable(this.additionalProperties.get(HOST_ENVIRONMENT_VARIABLE_NAME).toString());
            this.additionalProperties.put("x-codegen-host-env", this.hostEnvironmentVariable);
        }
        if (this.additionalProperties.containsKey(BASIC_AUTH_ENVIRONMENT_VARIABLE_NAME)) {
            this.setBasicAuthEnvironmentVariable(this.additionalProperties.get(BASIC_AUTH_ENVIRONMENT_VARIABLE_NAME).toString());
            this.additionalProperties.put("x-codegen-basicauth-env", this.basicAuthEnvironmentVariable);
        }
        if (this.additionalProperties.containsKey(APIKEY_AUTH_ENVIRONMENT_VARIABLE_NAME)) {
            this.setApiKeyAuthEnvironmentVariable(this.additionalProperties.get(APIKEY_AUTH_ENVIRONMENT_VARIABLE_NAME).toString());
            this.additionalProperties.put("x-codegen-apikey-env", this.apiKeyAuthEnvironmentVariable);
        }
        this.supportingFiles.add(new SupportingFile("client.mustache", "", this.scriptName));
        this.supportingFiles.add(new SupportingFile("bash-completion.mustache", "", this.scriptName + ".bash-completion"));
        this.supportingFiles.add(new SupportingFile("zsh-completion.mustache", "", "_" + this.scriptName));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
    }

    public void setCurlOptions(String curlOptions) {
        this.curlOptions = curlOptions;
    }

    public void setProcessMarkdown(boolean processMarkdown) {
        this.processMarkdown = processMarkdown;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public void setGenerateBashCompletion(boolean generateBashCompletion) {
        this.generateBashCompletion = generateBashCompletion;
    }

    public void setGenerateZshCompletion(boolean generateZshCompletion) {
        this.generateZshCompletion = generateZshCompletion;
    }

    public void setHostEnvironmentVariable(String hostEnvironmentVariable) {
        this.hostEnvironmentVariable = hostEnvironmentVariable;
    }

    public void setBasicAuthEnvironmentVariable(String basicAuthEnvironmentVariable) {
        this.basicAuthEnvironmentVariable = basicAuthEnvironmentVariable;
    }

    public void setApiKeyAuthEnvironmentVariable(String apiKeyAuthEnvironmentVariable) {
        this.apiKeyAuthEnvironmentVariable = apiKeyAuthEnvironmentVariable;
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder;
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public CodegenParameter fromParameter(Parameter param, Set<String> imports) {
        SerializableParameter sparam;
        CodegenParameter p = super.fromParameter(param, imports);
        if (param instanceof BodyParameter) {
            Model model = ((BodyParameter)param).getSchema();
        } else if (param instanceof SerializableParameter && (sparam = (SerializableParameter)param).getCollectionFormat() != null && !sparam.getCollectionFormat().isEmpty()) {
            String collectionFormat = sparam.getCollectionFormat();
            if (sparam.isExclusiveMaximum() != null && sparam.isExclusiveMaximum().booleanValue()) {
                p.vendorExtensions.put("x-codegen-collection-max-items", sparam.getMaxItems());
            }
            if (sparam.isExclusiveMinimum() != null && sparam.isExclusiveMinimum().booleanValue()) {
                p.vendorExtensions.put("x-codegen-collection-min-items", sparam.getMinItems());
            }
            if (collectionFormat.equals("multi") && param.getIn().equals("query")) {
                p.vendorExtensions.put("x-codegen-collection-multi", true);
            } else if (collectionFormat.equals("csv")) {
                p.vendorExtensions.put("x-codegen-collection-csv", true);
            } else if (collectionFormat.equals("ssv")) {
                p.vendorExtensions.put("x-codegen-collection-ssv", true);
            } else if (collectionFormat.equals("tsv")) {
                p.vendorExtensions.put("x-codegen-collection-tsv", true);
            } else if (collectionFormat.equals("pipes")) {
                p.vendorExtensions.put("x-codegen-collection-pipes", true);
            }
        }
        return p;
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        String result = input.trim();
        result = this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)result).replace("\\/", "/")).replace("\\", "\\\\").replace("\"", "\\\""));
        if (this.processMarkdown) {
            result = result.replaceAll("(?m)(^|\\s)\\*{2}([\\w\\d ]+)\\*{2}($|\\s)", "\\$\\(tput bold\\) $2 \\$\\(tput sgr0\\)");
            result = result.replaceAll("(?m)(^|\\s)_{2}([\\w\\d ]+)_{2}($|\\s)", "\\$\\(tput bold\\) $2 \\$\\(tput sgr0\\)");
            result = result.replaceAll("(?m)(^|\\s)\\*{1}([\\w\\d ]+)\\*{1}($|\\s)", "\\$\\(tput dim\\) $2 \\$\\(tput sgr0\\)");
            result = result.replaceAll("(?m)(^|\\s)_{1}([\\w\\d ]+)_{1}($|\\s)", "\\$\\(tput dim\\) $2 \\$\\(tput sgr0\\)");
            result = result.replaceAll("(?m)^\\#\\s+(.+)$", "\n\\$\\(tput bold\\)\\$\\(tput setaf 7\\)$1\\$\\(tput sgr0\\)");
            result = result.replaceAll("(?m)^\\#\\#\\s+(.+)$", "\n\\$\\(tput bold\\)\\$\\(tput setaf 7\\)$1\\$\\(tput sgr0\\)");
            result = result.replaceAll("(?m)^\\#\\#\\#\\s+(.+)$", "\n\\$\\(tput bold\\)\\$\\(tput setaf 7\\)$1\\$\\(tput sgr0\\)");
            result = result.replaceAll("(?m)\\s*```.*$", "\n---");
            result = result.replaceAll("(?m)\\s*\\'\\'\\'.*$", "\n---");
            result = result.replaceAll("\\s+$", "");
        }
        return result;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        String result = input.replaceAll("`", "'");
        return result;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, swagger);
        if (op.vendorExtensions.containsKey("x-bash-codegen-description")) {
            String bash_description = (String)op.vendorExtensions.get("x-bash-codegen-description");
            op.vendorExtensions.put("x-bash-codegen-description", this.escapeText(bash_description));
        }
        if (op.vendorExtensions.containsKey("x-code-samples")) {
            List codesamples = (List)op.vendorExtensions.get("x-code-samples");
            for (Object codesample : codesamples) {
                ObjectNode codesample_object;
                if (!(codesample instanceof ObjectNode) || !(codesample_object = (ObjectNode)codesample).get("lang").asText().equals("Shell")) continue;
                op.vendorExtensions.put("x-bash-codegen-sample", this.escapeUnsafeCharacters(codesample_object.get("source").asText()));
            }
        }
        for (CodegenParameter p : op.bodyParams) {
            if (p.dataType == null || definitions.get(p.dataType) == null) continue;
            if (operation.getConsumes() != null && operation.getConsumes().contains("application/json") && definitions.get(p.dataType).getExample() != null) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    p.vendorExtensions.put("x-codegen-body-example", mapper.writerWithDefaultPrettyPrinter().writeValueAsString(definitions.get(p.dataType).getExample()));
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                continue;
            }
            p.vendorExtensions.put("x-codegen-body-example", definitions.get(p.dataType).getExample());
        }
        return op;
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        String bash_codegen_app_description;
        super.preprocessSwagger(swagger);
        if ("/".equals(swagger.getBasePath())) {
            swagger.setBasePath("");
        }
        if (swagger.getInfo() != null && swagger.getInfo().getVendorExtensions() != null && (bash_codegen_app_description = (String)swagger.getInfo().getVendorExtensions().get("x-bash-codegen-description")) != null) {
            bash_codegen_app_description = this.escapeText(bash_codegen_app_description);
            this.additionalProperties.put("x-bash-codegen-app-description", bash_codegen_app_description);
        }
    }
}

