/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptorBase;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.SpanOperationType;
import io.temporal.opentracing.internal.ContextAccessor;
import io.temporal.opentracing.internal.SpanFactory;

public class OpenTracingWorkflowClientCallsInterceptor
extends WorkflowClientCallsInterceptorBase {
    private final SpanFactory spanFactory;
    private final Tracer tracer;
    private final ContextAccessor contextAccessor;

    public OpenTracingWorkflowClientCallsInterceptor(WorkflowClientCallsInterceptor next, OpenTracingOptions options, SpanFactory spanFactory, ContextAccessor contextAccessor) {
        super(next);
        this.spanFactory = spanFactory;
        this.tracer = options.getTracer();
        this.contextAccessor = contextAccessor;
    }

    public WorkflowClientCallsInterceptor.WorkflowStartOutput start(WorkflowClientCallsInterceptor.WorkflowStartInput input) {
        Span workflowStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createWorkflowStartSpanBuilder(input, SpanOperationType.START_WORKFLOW).start(), input.getHeader(), this.tracer);
        try {
            WorkflowClientCallsInterceptor.WorkflowStartOutput workflowStartOutput;
            block9: {
                Scope ignored = this.tracer.scopeManager().activate(workflowStartSpan);
                try {
                    workflowStartOutput = super.start(input);
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return workflowStartOutput;
        }
        finally {
            workflowStartSpan.finish();
        }
    }

    public WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput signalWithStart(WorkflowClientCallsInterceptor.WorkflowSignalWithStartInput input) {
        WorkflowClientCallsInterceptor.WorkflowStartInput workflowStartInput = input.getWorkflowStartInput();
        Span workflowStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createWorkflowStartSpanBuilder(workflowStartInput, SpanOperationType.SIGNAL_WITH_START_WORKFLOW).start(), workflowStartInput.getHeader(), this.tracer);
        try {
            WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput workflowSignalWithStartOutput;
            block9: {
                Scope ignored = this.tracer.scopeManager().activate(workflowStartSpan);
                try {
                    workflowSignalWithStartOutput = super.signalWithStart(input);
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return workflowSignalWithStartOutput;
        }
        finally {
            workflowStartSpan.finish();
        }
    }

    private Tracer.SpanBuilder createWorkflowStartSpanBuilder(WorkflowClientCallsInterceptor.WorkflowStartInput input, SpanOperationType operationType) {
        return this.spanFactory.createWorkflowStartSpan(this.tracer, operationType, input.getWorkflowType(), System.currentTimeMillis(), input.getWorkflowId());
    }
}

