/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptorBase;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.internal.ContextAccessor;
import io.temporal.opentracing.internal.OpenTracingWorkflowOutboundCallsInterceptor;
import io.temporal.opentracing.internal.SpanFactory;
import io.temporal.workflow.Workflow;

public class OpenTracingWorkflowInboundCallsInterceptor
extends WorkflowInboundCallsInterceptorBase {
    private final OpenTracingOptions options;
    private final SpanFactory spanFactory;
    private final ContextAccessor contextAccessor;

    public OpenTracingWorkflowInboundCallsInterceptor(WorkflowInboundCallsInterceptor next, OpenTracingOptions options, SpanFactory spanFactory, ContextAccessor contextAccessor) {
        super(next);
        this.options = options;
        this.spanFactory = spanFactory;
        this.contextAccessor = contextAccessor;
    }

    public void init(WorkflowOutboundCallsInterceptor outboundCalls) {
        super.init((WorkflowOutboundCallsInterceptor)new OpenTracingWorkflowOutboundCallsInterceptor(outboundCalls, this.options, this.spanFactory, this.contextAccessor));
    }

    public WorkflowInboundCallsInterceptor.WorkflowOutput execute(WorkflowInboundCallsInterceptor.WorkflowInput input) {
        Tracer tracer = this.options.getTracer();
        SpanContext rootSpanContext = this.contextAccessor.readSpanContextFromHeader(input.getHeader(), tracer);
        Span workflowRunSpan = this.spanFactory.createWorkflowRunSpan(tracer, Workflow.getInfo().getWorkflowType(), Workflow.currentTimeMillis(), Workflow.getInfo().getWorkflowId(), Workflow.getInfo().getRunId(), rootSpanContext).start();
        try {
            WorkflowInboundCallsInterceptor.WorkflowOutput workflowOutput;
            block13: {
                Scope scope = tracer.scopeManager().activate(workflowRunSpan);
                try {
                    workflowOutput = super.execute(input);
                    if (scope == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        if (t instanceof DestroyWorkflowThreadError) {
                            this.spanFactory.logEviction(workflowRunSpan);
                        } else {
                            this.spanFactory.logFail(workflowRunSpan, t);
                        }
                        throw t;
                    }
                }
                scope.close();
            }
            return workflowOutput;
        }
        finally {
            workflowRunSpan.finish();
        }
    }
}

