/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.grpc.Deadline;
import io.grpc.Status;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.HistoryEventFilterType;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.HistoryEventOrBuilder;
import io.temporal.api.taskqueue.v1.StickyExecutionAttributes;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.failure.ApplicationFailure;
import io.temporal.internal.common.WorkflowExecutionHistory;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.RequestContext;
import io.temporal.internal.testservice.SelfAdvancingTimer;
import io.temporal.internal.testservice.TaskQueue;
import io.temporal.internal.testservice.TestWorkflowStore;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestWorkflowStoreImpl
implements TestWorkflowStore {
    private static final Logger log = LoggerFactory.getLogger(TestWorkflowStoreImpl.class);
    private final Lock lock = new ReentrantLock();
    private final Map<ExecutionId, HistoryStore> histories = new HashMap<ExecutionId, HistoryStore>();
    private final Map<TestWorkflowStore.TaskQueueId, TaskQueue<PollActivityTaskQueueResponse.Builder>> activityTaskQueues = new HashMap<TestWorkflowStore.TaskQueueId, TaskQueue<PollActivityTaskQueueResponse.Builder>>();
    private final Map<TestWorkflowStore.TaskQueueId, TaskQueue<PollWorkflowTaskQueueResponse.Builder>> workflowTaskQueues = new HashMap<TestWorkflowStore.TaskQueueId, TaskQueue<PollWorkflowTaskQueueResponse.Builder>>();
    private final SelfAdvancingTimer selfAdvancingTimer;

    public TestWorkflowStoreImpl(SelfAdvancingTimer selfAdvancingTimer) {
        this.selfAdvancingTimer = selfAdvancingTimer;
    }

    @Override
    public Timestamp currentTime() {
        return Timestamps.fromMillis((long)this.selfAdvancingTimer.getClock().getAsLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long save(RequestContext ctx) {
        List<RequestContext.Timer> timers;
        List<TestWorkflowStore.ActivityTask> activityTasks;
        long result;
        this.lock.lock();
        try {
            ExecutionId executionId = ctx.getExecutionId();
            HistoryStore history = this.histories.get(executionId);
            List<HistoryEvent> events = ctx.getEvents();
            if (history == null) {
                if (events.isEmpty() || events.get(0).getEventType() != EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED) {
                    throw new IllegalStateException("No history found for " + executionId);
                }
                history = new HistoryStore(executionId, this.lock);
                this.histories.put(executionId, history);
            }
            history.checkNextEventId(ctx.getInitialEventId());
            history.addAllLocked(events, ctx.currentTime());
            result = history.getNextEventIdLocked();
            this.selfAdvancingTimer.updateLocks(ctx.getTimerLocks());
            ctx.fireCallbacks(history.getEventsLocked().size());
        }
        finally {
            this.lock.unlock();
        }
        TestWorkflowStore.WorkflowTask workflowTask = ctx.getWorkflowTask();
        if (workflowTask != null) {
            StickyExecutionAttributes attributes = ctx.getWorkflowMutableState().getStickyExecutionAttributes();
            TestWorkflowStore.TaskQueueId id = new TestWorkflowStore.TaskQueueId(workflowTask.getTaskQueueId().getNamespace(), attributes == null ? workflowTask.getTaskQueueId().getTaskQueueName() : attributes.getWorkerTaskQueue().getName());
            if (id.getTaskQueueName().isEmpty() || id.getNamespace().isEmpty()) {
                throw Status.INTERNAL.withDescription("Invalid TaskQueueId: " + id).asRuntimeException();
            }
            TaskQueue<PollWorkflowTaskQueueResponse.Builder> workflowTaskQueue = this.getWorkflowTaskQueueQueue(id);
            workflowTaskQueue.add(workflowTask.getTask());
        }
        if ((activityTasks = ctx.getActivityTasks()) != null) {
            for (TestWorkflowStore.ActivityTask activityTask : activityTasks) {
                TaskQueue<PollActivityTaskQueueResponse.Builder> activityTaskQueue = this.getActivityTaskQueueQueue(activityTask.getTaskQueueId());
                activityTaskQueue.add(activityTask.getTask());
            }
        }
        if ((timers = ctx.getTimers()) != null) {
            for (RequestContext.Timer t : timers) {
                log.trace("scheduling timer with " + t.getDelay() + "delay. Current time=" + this.currentTime());
                Functions.Proc cancellationHandle = this.selfAdvancingTimer.schedule(t.getDelay(), t.getCallback(), t.getTaskInfo());
                t.setCancellationHandle(cancellationHandle);
            }
        }
        return result;
    }

    @Override
    public void applyTimersAndLocks(RequestContext ctx) {
        this.lock.lock();
        try {
            this.selfAdvancingTimer.updateLocks(ctx.getTimerLocks());
        }
        finally {
            this.lock.unlock();
        }
        List<RequestContext.Timer> timers = ctx.getTimers();
        if (timers != null) {
            for (RequestContext.Timer t : timers) {
                Functions.Proc cancellationHandle = this.selfAdvancingTimer.schedule(t.getDelay(), t.getCallback(), t.getTaskInfo());
                t.setCancellationHandle(cancellationHandle);
            }
        }
        ctx.clearTimersAndLocks();
    }

    @Override
    public void registerDelayedCallback(Duration delay, Runnable r) {
        this.selfAdvancingTimer.schedule(delay, r, "registerDelayedCallback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskQueue<PollActivityTaskQueueResponse.Builder> getActivityTaskQueueQueue(TestWorkflowStore.TaskQueueId taskQueueId) {
        this.lock.lock();
        try {
            TaskQueue<Object> activityTaskQueue = this.activityTaskQueues.get(taskQueueId);
            if (activityTaskQueue == null) {
                activityTaskQueue = new TaskQueue();
                this.activityTaskQueues.put(taskQueueId, activityTaskQueue);
            }
            TaskQueue<PollActivityTaskQueueResponse.Builder> taskQueue = activityTaskQueue;
            return taskQueue;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskQueue<PollWorkflowTaskQueueResponse.Builder> getWorkflowTaskQueueQueue(TestWorkflowStore.TaskQueueId taskQueueId) {
        this.lock.lock();
        try {
            TaskQueue<Object> workflowTaskQueue = this.workflowTaskQueues.get(taskQueueId);
            if (workflowTaskQueue == null) {
                workflowTaskQueue = new TaskQueue();
                this.workflowTaskQueues.put(taskQueueId, workflowTaskQueue);
            }
            TaskQueue<PollWorkflowTaskQueueResponse.Builder> taskQueue = workflowTaskQueue;
            return taskQueue;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Future<PollWorkflowTaskQueueResponse.Builder> pollWorkflowTaskQueue(PollWorkflowTaskQueueRequest pollRequest) {
        TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(pollRequest.getNamespace(), pollRequest.getTaskQueue().getName());
        return this.getWorkflowTaskQueueQueue(taskQueueId).poll();
    }

    @Override
    public Future<PollActivityTaskQueueResponse.Builder> pollActivityTaskQueue(PollActivityTaskQueueRequest pollRequest) {
        TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(pollRequest.getNamespace(), pollRequest.getTaskQueue().getName());
        return this.getActivityTaskQueueQueue(taskQueueId).poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendQueryTask(ExecutionId executionId, TestWorkflowStore.TaskQueueId taskQueue, PollWorkflowTaskQueueResponse.Builder task) {
        this.lock.lock();
        try {
            HistoryStore historyStore = this.getHistoryStore(executionId);
            ArrayList<HistoryEvent> events = new ArrayList<HistoryEvent>(historyStore.getEventsLocked());
            History.Builder history = History.newBuilder();
            PeekingIterator iterator = Iterators.peekingIterator(events.iterator());
            long startedEventId = 0L;
            long previousStaredEventId = 0L;
            while (iterator.hasNext()) {
                HistoryEvent event = (HistoryEvent)iterator.next();
                if (event.getEventType() == EventType.EVENT_TYPE_WORKFLOW_TASK_STARTED) {
                    if (iterator.hasNext() && ((HistoryEvent)iterator.peek()).getEventType() != EventType.EVENT_TYPE_WORKFLOW_TASK_COMPLETED) continue;
                    startedEventId = previousStaredEventId = event.getEventId();
                    continue;
                }
                if (!WorkflowExecutionUtils.isWorkflowExecutionClosedEvent((HistoryEventOrBuilder)event)) continue;
                startedEventId = 0L;
                if (!iterator.hasNext()) continue;
                throw Status.INTERNAL.withDescription("Unexpected event after the completion event: " + iterator.peek()).asRuntimeException();
            }
            task.setPreviousStartedEventId(previousStaredEventId);
            task.setStartedEventId(startedEventId);
            if (taskQueue.getTaskQueueName().equals(task.getWorkflowExecutionTaskQueue().getName())) {
                history.addAllEvents(events);
            } else {
                history.addAllEvents(new ArrayList());
            }
            task.setHistory(history);
        }
        finally {
            this.lock.unlock();
        }
        TaskQueue<PollWorkflowTaskQueueResponse.Builder> workflowTaskQueue = this.getWorkflowTaskQueueQueue(taskQueue);
        workflowTaskQueue.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(ExecutionId executionId, GetWorkflowExecutionHistoryRequest getRequest, Deadline deadlineToReturnEmptyResponse) {
        long expectedNextEventId;
        HistoryStore history;
        this.lock.lock();
        try {
            history = this.getHistoryStore(executionId);
            if (!getRequest.getWaitNewEvent()) {
                List<HistoryEvent> events = history.getEventsLocked();
                List eventsCopy = events.stream().filter(e -> {
                    if (getRequest.getHistoryEventFilterType() != HistoryEventFilterType.HISTORY_EVENT_FILTER_TYPE_CLOSE_EVENT) {
                        return true;
                    }
                    return WorkflowExecutionUtils.isWorkflowExecutionClosedEvent((HistoryEventOrBuilder)e);
                }).collect(Collectors.toList());
                GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistoryResponse = GetWorkflowExecutionHistoryResponse.newBuilder().setHistory(History.newBuilder().addAllEvents(eventsCopy)).build();
                return getWorkflowExecutionHistoryResponse;
            }
            expectedNextEventId = history.getNextEventIdLocked();
        }
        finally {
            this.lock.unlock();
        }
        List<HistoryEvent> events = history.waitForNewEvents(expectedNextEventId, getRequest.getHistoryEventFilterType(), deadlineToReturnEmptyResponse);
        GetWorkflowExecutionHistoryResponse.Builder result = GetWorkflowExecutionHistoryResponse.newBuilder();
        if (events != null) {
            result.setHistory(History.newBuilder().addAllEvents(events));
        }
        return result.build();
    }

    private HistoryStore getHistoryStore(ExecutionId executionId) {
        HistoryStore result = this.histories.get(executionId);
        if (result == null) {
            WorkflowExecution execution = executionId.getExecution();
            throw Status.NOT_FOUND.withDescription(String.format("Workflow execution result not found.  WorkflowId: %s, RunId: %s", execution.getWorkflowId(), execution.getRunId())).asRuntimeException();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getDiagnostics(StringBuilder result) {
        result.append("Stored Workflows:\n");
        this.lock.lock();
        try {
            for (Map.Entry<ExecutionId, HistoryStore> entry : this.histories.entrySet()) {
                result.append(entry.getKey());
                result.append("\n\n");
                result.append(new WorkflowExecutionHistory(History.newBuilder().addAllEvents(entry.getValue().getEventsLocked()).build()).toProtoText(true));
                result.append("\n");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<WorkflowExecutionInfo> listWorkflows(TestWorkflowStore.WorkflowState state, Optional<String> filterWorkflowId) {
        ArrayList<WorkflowExecutionInfo> result = new ArrayList<WorkflowExecutionInfo>();
        for (Map.Entry<ExecutionId, HistoryStore> entry : this.histories.entrySet()) {
            ExecutionId executionId = entry.getKey();
            String workflowId = executionId.getWorkflowId().getWorkflowId();
            if (filterWorkflowId.isPresent() && !workflowId.equals(filterWorkflowId.get())) continue;
            if (state == TestWorkflowStore.WorkflowState.OPEN) {
                if (entry.getValue().isCompleted()) continue;
                result.add(this.constructWorkflowExecutionInfo(entry, executionId, WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_RUNNING));
                continue;
            }
            if (!entry.getValue().isCompleted()) continue;
            List<HistoryEvent> history = entry.getValue().getHistory();
            WorkflowExecutionStatus status = WorkflowExecutionUtils.getCloseStatus((HistoryEvent)history.get(history.size() - 1));
            result.add(this.constructWorkflowExecutionInfo(entry, executionId, status));
        }
        return result;
    }

    private WorkflowExecutionInfo constructWorkflowExecutionInfo(Map.Entry<ExecutionId, HistoryStore> entry, ExecutionId executionId, WorkflowExecutionStatus status) {
        List<HistoryEvent> history = entry.getValue().getHistory();
        WorkflowExecutionInfo.Builder info = WorkflowExecutionInfo.newBuilder().setExecution(executionId.getExecution()).setHistoryLength((long)history.size()).setStartTime(history.get(0).getEventTime()).setType(history.get(0).getWorkflowExecutionStartedEventAttributes().getWorkflowType());
        if (status != null) {
            info.setStatus(status);
        }
        return info.build();
    }

    @Override
    public void close() {
        this.selfAdvancingTimer.shutdown();
    }

    private static class HistoryStore {
        private final ExecutionId id;
        private final Lock lock;
        private final Condition newEventsCondition;
        private final List<HistoryEvent> history = new ArrayList<HistoryEvent>();
        private boolean completed;

        private HistoryStore(ExecutionId id, Lock lock) {
            this.id = id;
            this.lock = lock;
            this.newEventsCondition = lock.newCondition();
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public List<HistoryEvent> getHistory() {
            return this.history;
        }

        private void checkNextEventId(long nextEventId) {
            if (nextEventId != (long)this.history.size() + 1L && nextEventId != 0L && this.history.size() != 0) {
                throw new IllegalStateException("NextEventId=" + nextEventId + ", historySize=" + this.history.size() + " for " + this.id);
            }
        }

        void addAllLocked(List<HistoryEvent> events, Timestamp eventTime) {
            for (HistoryEvent event : events) {
                HistoryEvent.Builder eBuilder = event.toBuilder();
                if (this.completed) {
                    throw ApplicationFailure.newNonRetryableFailure((String)"Workflow execution completed.", (String)"test", (Object[])new Object[0]);
                }
                eBuilder.setEventId((long)this.history.size() + 1L);
                if (Timestamps.toMillis((Timestamp)eBuilder.getEventTime()) == 0L) {
                    eBuilder.setEventTime(eventTime);
                }
                this.history.add(eBuilder.build());
                this.completed = this.completed || WorkflowExecutionUtils.isWorkflowExecutionClosedEvent((HistoryEventOrBuilder)eBuilder);
            }
            this.newEventsCondition.signalAll();
        }

        long getNextEventIdLocked() {
            return (long)this.history.size() + 1L;
        }

        List<HistoryEvent> getEventsLocked() {
            return this.history;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        List<HistoryEvent> waitForNewEvents(long expectedNextEventId, HistoryEventFilterType filterType, Deadline deadline) {
            block15: {
                this.lock.lock();
                while (true) {
                    if (this.completed || this.getNextEventIdLocked() > expectedNextEventId) {
                        if (filterType == HistoryEventFilterType.HISTORY_EVENT_FILTER_TYPE_CLOSE_EVENT) {
                            if (this.completed) {
                                result = new ArrayList<HistoryEvent>(1);
                                result.add(this.history.get(this.history.size() - 1));
                                var6_8 = result;
                                return var6_8;
                            }
                            expectedNextEventId = this.getNextEventIdLocked();
                            continue;
                        }
                        break block15;
                    }
                    if (deadline == null) ** GOTO lbl24
                    toWait = deadline.timeRemaining(TimeUnit.MILLISECONDS);
                    if (toWait <= 0L) {
                        var7_12 = null;
                        return var7_12;
                    }
                    try {
                        this.newEventsCondition.await(toWait, TimeUnit.MILLISECONDS);
                        continue;
lbl24:
                        // 1 sources

                        this.newEventsCondition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        var6_11 = null;
                        return var6_11;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            result = new ArrayList<HistoryEvent>((int)(this.getNextEventIdLocked() - expectedNextEventId));
            i = (int)expectedNextEventId;
            while (true) {
                if ((long)i >= this.getNextEventIdLocked()) {
                    var6_10 = result;
                    return var6_10;
                }
                result.add(this.history.get(i));
                ++i;
            }
        }
    }
}

