/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.opentelemetry;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.ContextStorageProvider;
import io.opentelemetry.context.Scope;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.spi.context.storage.AccessMode;
import io.vertx.tracing.opentelemetry.OpenTelemetryTracingFactory;

public class VertxContextStorageProvider
implements ContextStorageProvider {
    public ContextStorage get() {
        return VertxContextStorage.INSTANCE;
    }

    public static enum VertxContextStorage implements ContextStorage
    {
        INSTANCE;


        public Scope attach(Context toAttach) {
            ContextInternal current = ContextInternal.current();
            if (current == null) {
                return ContextStorage.defaultStorage().attach(toAttach);
            }
            return this.attach(current, toAttach);
        }

        public Scope attach(ContextInternal vertxCtx, Context toAttach) {
            Context current = (Context)vertxCtx.getLocal(OpenTelemetryTracingFactory.ACTIVE_CONTEXT);
            if (current == toAttach) {
                return Scope.noop();
            }
            vertxCtx.putLocal(OpenTelemetryTracingFactory.ACTIVE_CONTEXT, AccessMode.CONCURRENT, (Object)toAttach);
            if (current == null) {
                return () -> vertxCtx.removeLocal(OpenTelemetryTracingFactory.ACTIVE_CONTEXT, AccessMode.CONCURRENT);
            }
            return () -> vertxCtx.putLocal(OpenTelemetryTracingFactory.ACTIVE_CONTEXT, AccessMode.CONCURRENT, (Object)current);
        }

        public Context current() {
            ContextInternal vertxCtx = ContextInternal.current();
            if (vertxCtx == null) {
                return ContextStorage.defaultStorage().current();
            }
            return (Context)vertxCtx.getLocal(OpenTelemetryTracingFactory.ACTIVE_CONTEXT);
        }
    }
}

