/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.configuration;

import java.io.Serializable;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.FailOnConstructionClass;
import javax.cache.expiry.Duration;
import org.junit.Assert;
import org.junit.Test;

public class FactoryBuilderTest {
    @Test
    public void testClassFactoryUsingClassName() {
        Factory factory = FactoryBuilder.factoryOf((String)String.class.getCanonicalName());
        Assert.assertNotNull((Object)factory.create());
    }

    @Test
    public void testClassFactoryFailOnCreation() {
        Factory factory = FactoryBuilder.factoryOf((String)FailOnConstructionClass.class.getCanonicalName());
        Assert.assertNotNull((Object)factory);
        try {
            factory.create();
            Assert.fail((String)"expected failure creating an instance of FailOnConstructionClass");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testClassFactoryEqualsHashCode() {
        Factory factory1 = FactoryBuilder.factoryOf((String)String.class.getCanonicalName());
        Factory factory2 = FactoryBuilder.factoryOf((String)String.class.getCanonicalName());
        Factory factory3 = FactoryBuilder.factoryOf((String)Integer.class.getCanonicalName());
        Assert.assertTrue((boolean)factory1.equals(factory1));
        Assert.assertTrue((boolean)factory1.equals(factory2));
        Assert.assertFalse((boolean)factory1.equals(factory3));
        Assert.assertFalse((boolean)factory1.equals(null));
        factory1.hashCode();
    }

    @Test
    public void testSingletonFactoryEqualsHashCode() {
        Factory factory1 = FactoryBuilder.factoryOf((Serializable)Duration.ETERNAL);
        Factory factory2 = FactoryBuilder.factoryOf((Serializable)Duration.ETERNAL);
        Factory factory3 = FactoryBuilder.factoryOf((Serializable)Duration.FIVE_MINUTES);
        Factory factory4 = FactoryBuilder.factoryOf((String)"stringFactory");
        Assert.assertTrue((boolean)factory1.equals(factory1));
        Assert.assertTrue((boolean)factory1.equals(factory2));
        Assert.assertFalse((boolean)factory1.equals(null));
        Assert.assertFalse((boolean)factory1.equals(factory3));
        Assert.assertFalse((boolean)factory1.equals(factory4));
        Assert.assertFalse((boolean)FactoryBuilder.factoryOf((Serializable)new StringBuffer("hello")).equals(FactoryBuilder.factoryOf((Serializable)new StringBuffer("hello"))));
        Assert.assertFalse((boolean)factory1.equals(null));
        factory1.hashCode();
    }
}

