/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheException;
import javax.cache.CacheLoader;
import javax.cache.CacheManager;
import javax.cache.CacheWriter;
import javax.cache.Caching;
import javax.cache.InvalidConfigurationException;
import javax.cache.implementation.AbstractCacheConfiguration;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static final int CACHE_LOADER_THREADS = 2;
    private final String cacheName;
    private final String cacheManagerName;
    private final ClassLoader classLoader;
    private final CacheConfiguration<K, V> configuration;
    private final CacheLoader<K, ? extends V> cacheLoader;
    private final CacheWriter<? super K, ? super V> cacheWriter;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public AbstractCache(String cacheName, String cacheManagerName, ClassLoader classLoader, CacheConfiguration<K, V> configuration, CacheLoader<K, ? extends V> cacheLoader, CacheWriter<? super K, ? super V> cacheWriter) {
        assert (configuration != null);
        this.configuration = configuration;
        assert (cacheName != null);
        this.cacheName = cacheName;
        assert (cacheManagerName != null);
        this.cacheManagerName = cacheManagerName;
        assert (classLoader != null);
        this.classLoader = classLoader;
        this.cacheWriter = cacheWriter;
        this.cacheLoader = cacheLoader;
    }

    public String getName() {
        return this.cacheName;
    }

    public CacheManager getCacheManager() {
        return Caching.getCacheManager((ClassLoader)this.classLoader, (String)this.cacheManagerName);
    }

    public CacheConfiguration<K, V> getConfiguration() {
        return this.configuration;
    }

    public void stop() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    protected CacheLoader<K, ? extends V> getCacheLoader() {
        return this.cacheLoader;
    }

    protected CacheWriter<? super K, ? super V> getCacheWriter() {
        return this.cacheWriter;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void submit(FutureTask<?> task) {
        this.executorService.submit(task);
    }

    public static abstract class Builder<K, V>
    implements CacheBuilder<K, V> {
        protected final String cacheName;
        protected final String cacheManagerName;
        protected final ClassLoader classLoader;
        protected CacheLoader<K, ? extends V> cacheLoader;
        protected CacheWriter<? super K, ? super V> cacheWriter;
        private final AbstractCacheConfiguration.Builder configurationBuilder;

        public Builder(String cacheName, String cacheManagerName, ClassLoader classLoader, AbstractCacheConfiguration.Builder configurationBuilder) {
            if (cacheName == null) {
                throw new NullPointerException("cacheName");
            }
            this.cacheName = cacheName;
            if (classLoader == null) {
                throw new NullPointerException("cacheLoader");
            }
            this.classLoader = classLoader;
            if (cacheManagerName == null) {
                throw new NullPointerException("cacheManagerName");
            }
            this.cacheManagerName = cacheManagerName;
            if (configurationBuilder == null) {
                throw new NullPointerException("configurationBuilder");
            }
            this.configurationBuilder = configurationBuilder;
        }

        public Builder<K, V> setCacheLoader(CacheLoader<K, ? extends V> cacheLoader) {
            if (cacheLoader == null) {
                throw new NullPointerException("cacheLoader");
            }
            this.cacheLoader = cacheLoader;
            return this;
        }

        public Builder<K, V> setCacheWriter(CacheWriter<? super K, ? super V> cacheWriter) {
            if (cacheWriter == null) {
                throw new NullPointerException("cacheWriter");
            }
            this.cacheWriter = cacheWriter;
            return this;
        }

        public Builder<K, V> setStatisticsEnabled(boolean enableStatistics) {
            this.configurationBuilder.setStatisticsEnabled(enableStatistics);
            return this;
        }

        public Builder<K, V> setReadThrough(boolean readThrough) {
            this.configurationBuilder.setReadThrough(readThrough);
            return this;
        }

        public Builder<K, V> setWriteThrough(boolean writeThrough) {
            this.configurationBuilder.setWriteThrough(writeThrough);
            return this;
        }

        public Builder<K, V> setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration duration) {
            if (type == null) {
                throw new NullPointerException();
            }
            if (duration == null) {
                throw new NullPointerException();
            }
            this.configurationBuilder.setExpiry(type, duration);
            return this;
        }

        public Builder<K, V> setStoreByValue(boolean storeByValue) {
            this.configurationBuilder.setStoreByValue(storeByValue);
            return this;
        }

        public Builder<K, V> setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
            this.configurationBuilder.setTransactionEnabled(isolationLevel, mode);
            return this;
        }

        protected CacheConfiguration<K, V> createCacheConfiguration() {
            CacheConfiguration configuration = this.configurationBuilder.build();
            if (configuration.isReadThrough() && this.cacheLoader == null) {
                throw new InvalidConfigurationException("cacheLoader");
            }
            if (configuration.isWriteThrough() && this.cacheWriter == null) {
                throw new InvalidConfigurationException("cacheWriter");
            }
            return configuration;
        }
    }
}

