/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheConfiguration;
import javax.cache.Caching;
import javax.cache.InvalidConfigurationException;
import javax.cache.OptionalFeature;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public abstract class AbstractCacheConfiguration
implements CacheConfiguration {
    private final boolean readThrough;
    private final boolean writeThrough;
    private final boolean storeByValue;
    private final AtomicBoolean statisticsEnabled;
    private volatile IsolationLevel isolationLevel;
    private volatile Mode transactionMode;
    private final CacheConfiguration.Duration[] timeToLive;

    public AbstractCacheConfiguration(boolean readThrough, boolean writeThrough, boolean storeByValue, boolean statisticsEnabled, IsolationLevel isolationLevel, Mode transactionMode, CacheConfiguration.Duration[] timeToLive) {
        this.readThrough = readThrough;
        this.writeThrough = writeThrough;
        this.storeByValue = storeByValue;
        this.statisticsEnabled = new AtomicBoolean(statisticsEnabled);
        this.isolationLevel = isolationLevel;
        this.transactionMode = transactionMode;
        this.timeToLive = timeToLive;
    }

    public boolean isReadThrough() {
        return this.readThrough;
    }

    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled.get();
    }

    public void setStatisticsEnabled(boolean enableStatistics) {
        this.statisticsEnabled.set(enableStatistics);
    }

    public CacheConfiguration.Duration getExpiry(CacheConfiguration.ExpiryType type) {
        return this.timeToLive[type.ordinal()];
    }

    public boolean isTransactionEnabled() {
        return this.isolationLevel != null && this.transactionMode != null;
    }

    public IsolationLevel getTransactionIsolationLevel() {
        return this.isolationLevel;
    }

    public Mode getTransactionMode() {
        return this.transactionMode;
    }

    public int hashCode() {
        int result = this.readThrough ? 1 : 0;
        result = 31 * result + (this.writeThrough ? 1 : 0);
        result = 31 * result + (this.isStatisticsEnabled() ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.timeToLive);
        result = 31 * result + (this.storeByValue ? 1 : 0);
        result = 31 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
        result = 31 * result + (this.transactionMode != null ? this.transactionMode.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheConfiguration)) {
            return false;
        }
        CacheConfiguration that = (CacheConfiguration)o;
        if (this.readThrough != that.isReadThrough()) {
            return false;
        }
        if (this.writeThrough != that.isWriteThrough()) {
            return false;
        }
        if (this.isStatisticsEnabled() != that.isStatisticsEnabled()) {
            return false;
        }
        for (CacheConfiguration.ExpiryType ttyType : CacheConfiguration.ExpiryType.values()) {
            if (this.getExpiry(ttyType) == that.getExpiry(ttyType)) continue;
            return false;
        }
        if (this.storeByValue != this.isStoreByValue()) {
            return false;
        }
        if (this.isolationLevel != that.getTransactionIsolationLevel()) {
            return false;
        }
        return this.transactionMode == that.getTransactionMode();
    }

    public static abstract class Builder {
        private static final boolean DEFAULT_READ_THROUGH = false;
        private static final boolean DEFAULT_WRITE_THROUGH = false;
        private static final boolean DEFAULT_STATISTICS_ENABLED = false;
        private static final CacheConfiguration.Duration DEFAULT_TIME_TO_LIVE = CacheConfiguration.Duration.ETERNAL;
        private static final boolean DEFAULT_STORE_BY_VALUE = true;
        private static final IsolationLevel DEFAULT_TRANSACTION_ISOLATION_LEVEL = IsolationLevel.NONE;
        private static final Mode DEFAULT_TRANSACTION_MODE = Mode.NONE;
        protected boolean readThrough = false;
        protected boolean writeThrough = false;
        protected boolean statisticsEnabled = false;
        protected final CacheConfiguration.Duration[] timeToLive;
        protected boolean storeByValue = true;
        protected IsolationLevel isolationLevel = DEFAULT_TRANSACTION_ISOLATION_LEVEL;
        protected Mode transactionMode = DEFAULT_TRANSACTION_MODE;

        public Builder() {
            this.timeToLive = new CacheConfiguration.Duration[CacheConfiguration.ExpiryType.values().length];
            for (int i = 0; i < this.timeToLive.length; ++i) {
                this.timeToLive[i] = DEFAULT_TIME_TO_LIVE;
            }
        }

        public abstract CacheConfiguration build();

        public Builder setReadThrough(boolean readThrough) {
            this.readThrough = readThrough;
            return this;
        }

        public Builder setWriteThrough(boolean writeThrough) {
            this.writeThrough = writeThrough;
            return this;
        }

        public Builder setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
            return this;
        }

        public Builder setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration duration) {
            if (type == null) {
                throw new NullPointerException();
            }
            if (duration == null) {
                throw new NullPointerException();
            }
            this.timeToLive[type.ordinal()] = duration.getDurationAmount() == 0L ? CacheConfiguration.Duration.ETERNAL : duration;
            return this;
        }

        public Builder setStoreByValue(boolean storeByValue) {
            if (!storeByValue && !Caching.isSupported((OptionalFeature)OptionalFeature.STORE_BY_REFERENCE)) {
                throw new InvalidConfigurationException("storeByValue");
            }
            this.storeByValue = storeByValue;
            return this;
        }

        public Builder setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
            if (!Caching.isSupported((OptionalFeature)OptionalFeature.TRANSACTIONS)) {
                throw new InvalidConfigurationException("transactionsEnabled");
            }
            this.isolationLevel = isolationLevel;
            this.transactionMode = mode;
            return this;
        }
    }
}

