/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.cache.CacheManager;
import javax.cache.CacheManagerFactory;
import javax.cache.CachingShutdownException;

public abstract class AbstractCacheManagerFactory
implements CacheManagerFactory {
    private final Map<ClassLoader, Map<String, CacheManager>> cacheManagers = new HashMap<ClassLoader, Map<String, CacheManager>>();

    public CacheManager getCacheManager(String name) {
        return this.getCacheManager(this.getDefaultClassLoader(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(ClassLoader classLoader, String name) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        Map<ClassLoader, Map<String, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            CacheManager cacheManager;
            Map<String, CacheManager> map2 = this.cacheManagers.get(classLoader);
            if (map2 == null) {
                map2 = new HashMap<String, CacheManager>();
                this.cacheManagers.put(classLoader, map2);
            }
            if ((cacheManager = map2.get(name)) == null) {
                cacheManager = this.createCacheManager(classLoader, name);
                map2.put(name, cacheManager);
            }
            return cacheManager;
        }
    }

    protected abstract CacheManager createCacheManager(ClassLoader var1, String var2);

    protected abstract ClassLoader getDefaultClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CachingShutdownException {
        Map<ClassLoader, Map<String, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            IdentityHashMap failures = new IdentityHashMap();
            for (Map<String, CacheManager> cacheManagerMap : this.cacheManagers.values()) {
                try {
                    this.shutdown(cacheManagerMap);
                }
                catch (CachingShutdownException e) {
                    failures.putAll(e.getFailures());
                }
            }
            this.cacheManagers.clear();
            if (!failures.isEmpty()) {
                throw new CachingShutdownException(failures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(ClassLoader classLoader) throws CachingShutdownException {
        Map<String, CacheManager> cacheManagerMap;
        Map<ClassLoader, Map<String, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            cacheManagerMap = this.cacheManagers.remove(classLoader);
        }
        if (cacheManagerMap == null) {
            return false;
        }
        this.shutdown(cacheManagerMap);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(ClassLoader classLoader, String name) throws CachingShutdownException {
        CacheManager cacheManager;
        Map<ClassLoader, Map<String, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            Map<String, CacheManager> cacheManagerMap = this.cacheManagers.get(classLoader);
            cacheManager = cacheManagerMap.remove(name);
            if (cacheManagerMap.isEmpty()) {
                this.cacheManagers.remove(classLoader);
            }
        }
        if (cacheManager == null) {
            return false;
        }
        cacheManager.shutdown();
        return true;
    }

    private void shutdown(Map<String, CacheManager> cacheManagerMap) throws CachingShutdownException {
        IdentityHashMap<CacheManager, Exception> failures = new IdentityHashMap<CacheManager, Exception>();
        for (CacheManager cacheManager : cacheManagerMap.values()) {
            try {
                cacheManager.shutdown();
            }
            catch (Exception e) {
                failures.put(cacheManager, e);
            }
        }
        if (!failures.isEmpty()) {
            throw new CachingShutdownException(failures);
        }
    }
}

