/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.event.CacheEntryListener;
import javax.cache.implementation.AbstractCache;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public class DelegatingCacheBuilder<K, V>
implements CacheBuilder<K, V> {
    private final AbstractCache.Builder<K, V> cacheBuilder;

    public DelegatingCacheBuilder(AbstractCache.Builder<K, V> cacheBuilder) {
        this.cacheBuilder = cacheBuilder;
    }

    public Cache<K, V> build() {
        return this.cacheBuilder.build();
    }

    public CacheBuilder<K, V> setCacheLoader(CacheLoader<K, ? extends V> cacheLoader) {
        this.cacheBuilder.setCacheLoader((CacheLoader)cacheLoader);
        return this;
    }

    public CacheBuilder<K, V> setCacheWriter(CacheWriter<? super K, ? super V> cacheWriter) {
        this.cacheBuilder.setCacheWriter((CacheWriter)cacheWriter);
        return this;
    }

    public CacheBuilder<K, V> registerCacheEntryListener(CacheEntryListener<K, V> listener) {
        this.cacheBuilder.registerCacheEntryListener(listener);
        return this;
    }

    public CacheBuilder<K, V> setStoreByValue(boolean storeByValue) {
        this.cacheBuilder.setStoreByValue(storeByValue);
        return this;
    }

    public CacheBuilder<K, V> setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
        if (IsolationLevel.NONE.equals((Object)isolationLevel)) {
            throw new IllegalArgumentException("The none isolation level is not permitted.");
        }
        if (Mode.NONE.equals((Object)mode)) {
            throw new IllegalArgumentException("The none Mode is not permitted.");
        }
        this.cacheBuilder.setTransactionEnabled(isolationLevel, mode);
        return this;
    }

    public CacheBuilder<K, V> setStatisticsEnabled(boolean enableStatistics) {
        this.cacheBuilder.setStatisticsEnabled(enableStatistics);
        return this;
    }

    public CacheBuilder<K, V> setReadThrough(boolean readThrough) {
        this.cacheBuilder.setReadThrough(readThrough);
        return this;
    }

    public CacheBuilder<K, V> setWriteThrough(boolean writeThrough) {
        this.cacheBuilder.setWriteThrough(writeThrough);
        return this;
    }

    public CacheBuilder<K, V> setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration duration) {
        this.cacheBuilder.setExpiry(type, duration);
        return this;
    }
}

