/*
 * @(#) BackAction.java 1.3 - last change made 07/09/03
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

import java.awt.*;
import java.awt.event.*;
import javax.help.*;
import javax.help.event.*;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import javax.swing.*;

/**
 *
 * @author Stepan Marek
 * @version	1.3	07/09/03
 */
public class BackAction extends AbstractHelpAction implements MouseListener, HelpHistoryModelListener {
    
    private static final String NAME = "BackAction";

    private static final int DELAY = 500;    
    private Timer timer;
    private HelpHistoryModel historyModel;
    
    /** Creates new BackAction */
    public BackAction(Object control) {
        super(control, NAME);
        if (control instanceof JHelp) {
            JHelp help = (JHelp)control;
            historyModel = help.getHistoryModel();
            historyModel.addHelpHistoryModelListener(this);
            
            setEnabled(historyModel.getIndex() > 0);
            
            putValue("icon", UIManager.getIcon(NAME + ".icon"));
            
	    Locale locale = null;
	    try {
		locale = help.getModel().getHelpSet().getLocale();
	    } catch (NullPointerException npe) {
		locale = Locale.getDefault();
	    }
            putValue("tooltip", HelpUtilities.getString(locale, "tooltip." + NAME));
            putValue("access", HelpUtilities.getString(locale, "access." + NAME));
        }
    }

    /**
     * Invoked when the mouse exits a component.
     */
    public void mouseExited(MouseEvent e) {
    }
    
    /**
     * Invoked when a mouse button has been released on a component.
     */
    public void mouseReleased(MouseEvent e) {
        if (timer != null) {
            timer.stop();
        }
    }
    
    /**
     * Invoked when a mouse button has been pressed on a component.
     */
    public void mousePressed(MouseEvent e) {
        timer = new Timer(DELAY, new TimeListener(e));
        timer.start();
    }
    
    /**
     * Invoked when the mouse has been clicked on a component.
     */
    public void mouseClicked(MouseEvent e) {
        if ((historyModel != null) && isEnabled()) {
            historyModel.goBack();
        }
    }
    
    /**
     * Invoked when the mouse enters a component.
     */
    public void mouseEntered(MouseEvent e) {
    }

    private class TimeListener implements ActionListener {
        
        private MouseEvent e;
        
        public TimeListener(MouseEvent e) {
            this.e = e;
        }
        
        public void actionPerformed(ActionEvent evt) {
            timer.stop();
            if (BackAction.this.isEnabled()) {
                BackAction.this.showBackwardHistory(e);
            }
        }
    }

    private class HistoryActionListener implements ActionListener {
        
        private int index;
        
        public HistoryActionListener(int index) {
            this.index = index;          
        }
        
        public void actionPerformed(java.awt.event.ActionEvent event) {
            if(historyModel != null) {
                historyModel.setHistoryEntry(index);
            }
        }        
    }

    private void showBackwardHistory(MouseEvent e) {
        
        JPopupMenu backwardMenu = new JPopupMenu("Backward History");
        
        if (historyModel == null) {
            return;
        }
        
        Stack menuStack = new Stack();
        Locale locale = ((JHelp)getControl()).getModel().getHelpSet().getLocale();
        Enumeration items = historyModel.getBackwardHistory().elements();
        JMenuItem mi = null;
        //while(items.hasMoreElements()) {
        for (int i = 0; items.hasMoreElements(); i++) {
            HelpModelEvent item = (HelpModelEvent)items.nextElement();
            if (item != null) {
                String title = item.getHistoryName();
                if (title == null) {
                    title = HelpUtilities.getString(locale, "history.unknownTitle");
                }
                mi = new JMenuItem(title);
                //mi.setToolTipText(item.getURL().getPath());
                mi.addActionListener(new HistoryActionListener(i));
                menuStack.push(mi);
            }
        }
        int size = menuStack.size();
        for(int j = 0; j < size; j++) {
            backwardMenu.add((JMenuItem)menuStack.pop());
        }
        // if(e.isPopupTrigger())
        backwardMenu.show(e.getComponent(),e.getX(),e.getY());
    }
    
    /**
     * Tells the listener that the history has changed.
     * Will enable/disable the Action depending on the events previous flag
     *
     * @param e The HelpHistoryModelEvent
     */
    public void historyChanged(HelpHistoryModelEvent e) {
        setEnabled(e.isPrevious());
    }
    
}
