/*
  * @(#) FavoritesAction.java 1.2 - last change made 06/27/03
 *
 * Copyright (c) 2003 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.UIManager;

/**
 *
 * @author Roger Brinkley
 * @version   1.2     06/27/03
 */
public class FavoritesAction extends AbstractHelpAction implements ActionListener {
    
    private static final String NAME = "FavoritesAction";
    private JHelpFavoritesNavigator favorites=null;
    private ActionListener favoritesActionListener=null;

    /** Creates new FavoritesAction */
    public FavoritesAction(Object control) {
        super(control, NAME);
        if (control instanceof JHelp) {
            JHelp help = (JHelp)control;
	    for (Enumeration e = help.getHelpNavigators(); e.hasMoreElements();) {
		JHelpNavigator nav = (JHelpNavigator)e.nextElement();
		if(nav instanceof JHelpFavoritesNavigator) {
		    favorites = (JHelpFavoritesNavigator)nav;
		    favoritesActionListener = favorites.getAddAction();
		}
	    }
            
            setEnabled(favoritesActionListener != null);
            
            putValue("icon", UIManager.getIcon(NAME + ".icon"));
            
	    Locale locale = null;
	    try {
		locale = help.getModel().getHelpSet().getLocale();
	    } catch (NullPointerException npe) {
		locale = Locale.getDefault();
	    }
            putValue("tooltip", HelpUtilities.getString(locale, "tooltip." + NAME));
            putValue("access", HelpUtilities.getString(locale, "access." + NAME));
        }
    }

    public void actionPerformed(java.awt.event.ActionEvent event) {
	if (favoritesActionListener != null) {
	    favoritesActionListener.actionPerformed(event);
	}
    }

}
