/*
 * @(#) HelpHistoryModel.java 1.2 - last change made 09/04/01
 *
 * Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

/**
 * History Model for HelpModel
 *
 * @author  Richard Gregor
 * @version   1.2     09/04/01
 */

import java.awt.event.ActionListener;
import javax.help.event.*;
import java.io.Serializable;
import java.beans.*;
import java.util.Vector;
import javax.help.Map.ID;
import java.util.Enumeration;

/**
 * The interface to the history model.
 */
public interface HelpHistoryModel extends HelpModelListener, Serializable{
    /**
     * Adds a listener for the HelpHistoryModelEvent posted after the model has
     * changed.
     * 
     * @param l The listener to add.
     * @see javax.help.HelpHistoryModel#removeHelpHistoryModelListener
     */
    public void addHelpHistoryModelListener(HelpHistoryModelListener l);

    /**
     * Removes a listener previously added with <tt>addHelpHistoryModelListener</tt>
     *
     * @param l The listener to remove.
     * @see javax.help.HelpHistoryModel#addHelpHistoryModelListener
     */
    public void removeHelpHistoryModelListener(HelpHistoryModelListener l);
       
    /**
     * Discards a history
     */
    public void discard();
    /**
     * Sets a next history entry
     */
    public void goForward();
    
    /**
     * Sets a previous history entry
     */
    public void goBack();
    
    /**
     * Returns a backward history list
     */
    public Vector getBackwardHistory();
    
    /**
     * Returns a forward history list
     */
    public Vector getForwardHistory();
    
    /**
     * Sets the current history entry
     *
     * @param index The index of history entry
     */
    public void setHistoryEntry(int index);
    
    /**
     * Removes entries related to removed HelpSet from history
     *
     * @param hs The removed HelpSet
     */
    public void removeHelpSet(HelpSet hs);
    
    /**
     * Returns a history
     */
    public Vector getHistory();
    
    /**
     * Returns a current history position
     *
     * @return The history index
     */
    public int getIndex();
    
    /**
     * Sets the HelpModel
     *
     * @param model The HeplModel
     */
    public void setHelpModel(HelpModel model);
    

}

