/*
 * @(#) JHelpGlossaryNavigator.java 1.1 - last change made 07/19/01
 *
 * Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package javax.help;

import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.UIDefaults;
import javax.swing.LookAndFeel;
import javax.help.*;
import java.beans.*;

/**
 * JHelpGlossaryNavigator is a JHelpNavigator for a Glossary
 *
 * @author Roger Brinkley
 * @author Richard Gregor
 * @version   1.1     07/19/01
 */

public class JHelpGlossaryNavigator extends JHelpNavigator {

    /**
     * Creates JHelpGlossaryNavigator from given GlossaryView
     *
     * @param info The GlossaryView
     */
    public JHelpGlossaryNavigator(NavigatorView info) {
	super(info);
    }
    /**
     * Creates JHelpGlossaryNavigator from given GlossaryView and HelpModel
     *
     * @param info The GlossaryView
     * @param model The HelpModel
     */
    public JHelpGlossaryNavigator(NavigatorView info, HelpModel model) {
	super(info, model);
    }

    /**
     * Creates JHelpGlossaryNavigator from given HelpSet, name and title
     *
     * @param hs The HelpSet
     * @param name The name of GlossaryView
     * @param title The title
     */

    public JHelpGlossaryNavigator(HelpSet hs, String name, String title)
	throws InvalidNavigatorViewException
    {
	super(new GlossaryView(hs, name, title, null));
    }


    /**
     * Returns UIClassID
     *
     * @return The ID of UIClass representing JHelpGlossaryNavigator
     */
    public String getUIClassID() {
	return "HelpGlossaryNavigatorUI";
    }



    private static final boolean debug = false;
    private static void debug(Object m1, Object m2, Object m3) {
	if (debug) {
	    System.err.println("JHelpGlossaryNavigator: "+m1+m2+m3);
	}
    }
    private static void debug(Object m1) { debug(m1,null,null); }
    private static void debug(Object m1, Object m2) { debug(m1,m2,null); }
}
