/*
 * @(#) PrintSetupAction.java 1.2 - last change made 06/27/03
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.UIManager;
import com.sun.java.help.impl.JHelpPrintHandler;

/**
 *
 * @author Stepan Marek
 * @version	1.2	06/27/03
 */
public class PrintSetupAction extends AbstractHelpAction implements PropertyChangeListener, ActionListener {
    
    private static final String NAME = "PrintSetupAction";
    
    private JHelpPrintHandler handler = null;
    
    /** Creates new BackAction */
    public PrintSetupAction(Object control) {
        
        super(control, NAME);
        
        if (getControl() instanceof JHelp) {
            
            JHelp help = (JHelp)control;
            
            handler = JHelpPrintHandler.getJHelpPrintHandler(help);
            handler.addPropertyChangeListener(this);
            
	    Locale locale = null;
	    try {
		locale = help.getModel().getHelpSet().getLocale();
	    } catch (NullPointerException npe) {
		locale = Locale.getDefault();
	    }
            putValue("tooltip", HelpUtilities.getString(locale, "tooltip." + NAME));
            putValue("access", HelpUtilities.getString(locale, "access." + NAME));

        }
        
        putValue("icon", UIManager.getIcon(NAME + ".icon"));

    }

    public void actionPerformed(ActionEvent event) {
        if (handler != null) {
            handler.printSetup();
        }
    }
    
    /**
     * This method gets called when a bound property is changed.
     * @param evt A PropertyChangeEvent object describing the event source
     *  	and the property that has changed.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("enabled")) {
            setEnabled(((Boolean)evt.getNewValue()).booleanValue());
        }
    }
}
