/*
 * @(#) ReloadAction.java 1.2 - last change made 06/27/03
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

import java.awt.*;
import java.awt.event.*;
import javax.help.*;
import javax.help.event.*;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import javax.swing.*;

/**
 *
 * @author Roger Brinkley
 * @version	1.2	06/27/03
 */
public class ReloadAction extends AbstractHelpAction implements ActionListener {
    
    private static final String NAME = "ReloadAction";
    
    /** Creates new ReloadAction */
    public ReloadAction(Object control) {
        super(control, NAME);
        
        putValue("icon", UIManager.getIcon(NAME + ".icon"));
        
        if (control instanceof JHelp) {
	    JHelp help = (JHelp) control;
	    Locale locale = null;
	    try {
		locale = help.getModel().getHelpSet().getLocale();
	    } catch (NullPointerException npe) {
		locale = Locale.getDefault();
	    }

            putValue("tooltip", HelpUtilities.getString(locale, "tooltip." + NAME));
            putValue("access", HelpUtilities.getString(locale, "access." + NAME));
        }
    }
    
    public void actionPerformed(java.awt.event.ActionEvent event) {
	JHelp help = (JHelp)getControl();
	JHelpContentViewer viewer = help.getContentViewer();
	viewer.reload();
    }
}
