/*
 * @(#) SecondaryWindow.java 1.4 - last change made 02/26/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

import java.util.Hashtable;

/**
 * MainWindowPresentation is a class that will create a single main help 
 * window for an application. Although there is generally only one per
 * application there can  be multiple MainWindowPresentation.
 * By default it is a tri-paned fully decorated window
 * consisting of a toolbar, navigator pane, and help content view. By default
 * the class is not destroyed when the window exits.
 *
 * @author Roger D.Brinkley
 * @version	1.4	02/26/02
 * @since 2.0
 *
 * @see javax.help.WindowPresentation
 * @see javax.help.Presentation
 */

public class SecondaryWindow extends WindowPresentation {

    static private Hashtable windows = new Hashtable();
    private String name;

    private SecondaryWindow(HelpSet hs, String name) {
	super(hs);
	this.name = name;
    }

    /**
     * Get a named SecondaryWindow for a given HelpSet.
     * Named SecondaryWindows are stored. If a named 
     * SecondaryWindow exits then it is returned, otherwise a new
     * secondary window is created. If there is a HelpSet.Presentation of the
     * same name the presentation attibutes will be used, otherwise, the 
     * default HelpSet.Presentation is used.
     * 
     * @param hs The HelpSet used in this presentation
     * @param name The name of the Presentation to create - also the name
     *             of the HelpSet.Presentation to use.
     * @returns Presentation A unique MainWindowPresentation. 
     */
    static public Presentation getPresentation(HelpSet hs, String name) {
	debug ("getPresentation");
	SecondaryWindow swp;

	String winName = name;
	if (name == null) {
	    winName = "";
	}

	// Use the secondary window if one exists
	swp = (SecondaryWindow) windows.get(winName);
	if (swp != null) {
	    if (swp.getHelpSet() != hs) {
		swp.setHelpSet(hs);
	    }
	    return swp;
	}

	debug ("no Presentation - start again");
	swp = new SecondaryWindow(hs, winName);

	// Set the SecondaryWindow defaults
	swp.setViewDisplayed(false);
	swp.setToolbarDisplayed(false);
	swp.setDestroyOnExit(true);
	swp.setTitleFromDocument(true);

	if (hs != null) {
	    HelpSet.Presentation presentation = null;

	    // get a named presentation if one exists
	    if (name != null) {
		presentation = hs.getPresentation(name);
	    }

	    // get the default presentation if one exits
	    if (presentation == null) {
		presentation = hs.getDefaultPresentation();
	    }

	    // set the presentation
	    // a null is ok here as it will just return.
	    swp.setHelpSetPresentation(presentation);

	    windows.put(winName, swp);
	}
	return swp;
    }

    /**
     * Gets a SecondaryWindow if one exists. Does not 
     * create a Presentation if one does not exist.
     * 
     * @param name Name of the presentation to get
     * @return SecondaryWindow The found Presentation or null
     */
    static public SecondaryWindow getPresentation(String name) {
	debug ("getPresenation(name)");
	return (SecondaryWindow) windows.get(name);
    }

    /**
     * Destroy the SecondaryWindowPresentatin. Specifically remove it from
     * the list of SecondaryWindows.
     */
    public void destroy() {
	super.destroy();
	windows.remove(name);
    }

    /**
     * Debugging code...
     */

    private static final boolean debug = false;
    private static void debug(Object msg) {
	if (debug) {
	    System.err.println("SecondaryWindow: "+msg);
	}
    }
 
}
