/*
 *  @(#) TreeItem.java 1.27 - last change made 10/26/04
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

import javax.help.Map.ID;
import java.util.Locale;
import java.net.URL;
import java.io.Serializable;
import java.io.IOException;

/**
 * The base items known to TOC, Index and Favorites Navigators.
 *
 * @author Roger D. Brinkley
 * @author Eduardo Pelegri-Llopart
 * @author Richard Gregor
 * @version   1.27     10/26/04
 */

public class TreeItem implements Serializable
{

    /**
     * A state of expansion determined by the view
     */
    public static final int DEFAULT_EXPANSION = -1;

    /**
     * Show the children of the node collapsed in the view
     */
    public static final int COLLAPSE = 0;

    /**
     * Show the children of the node expanded in the view
     */
    public static final int EXPAND = 1;

    private String name;
    private ID id;
    protected Locale locale;
    private String mergeType;
    private int expand = DEFAULT_EXPANSION;
    private String presentation;
    private String presentationName;
    private HelpSet hs;

     /**
     * Create an TreeItem.
     *
     * @param id ID for the item. The ID can be null.
     * @param hs A HelpSet scoping this item.
     * @param locale The locale for this item
     */
    public TreeItem(ID id, HelpSet hs, Locale locale) {
	this.id = id;
	this.hs = hs;
	this.locale = locale;
    }

   /**
     * Creates a TreeItem.
     *
     * @param id ID for the item. Null is a valid ID.
     * @param The lang for this item. A null is valid and indicates the default
     * locale.
     */
    public TreeItem(ID id, Locale locale){
	this (id, null, locale);
    }
    /**
     * Creates a TreeItem.
     *
     * @param name The name for the item.
     */
    public TreeItem(String name){
        this(null,null, null);
        setName(name);
    }
    
    /**
     * Creates an empty TreeItem.
     */
    public TreeItem(){
        this(null,null);        
    }
    /**
     * Sets the name of the item.
     */
    public void setName(String name) {
	this.name = name;
    }

    /**
     * Returns the name of the item.
     */
    public String getName() {
	return name;
    }
    
    /**
     * Set the ID for the item.
     */
    public void setID (ID id) {
	this.id = id;
    }

    /**
     * Returns the ID for the item.
     */
    public ID getID() {
	return id;
    }

    /**
     * Returns the URL for the item.
     */
    public URL getURL() {
        try {
            return id.getURL();
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * Set the HelpSet for this TreeItem.
     */
    public void setHelpSet(HelpSet hs) {
	this.hs = hs;
    }

    /**
     * Returns the HelpSet scoping this IndexItem. Will return the ID HelpSet
     * if one exists. Null otherwise
     */
    public HelpSet getHelpSet() {
	return hs;
    }
    
    /**
     * Returns the locale for the item.
     */
    public Locale getLocale() {
	return locale;
    }
    
    /**
     * Sets the merge type
     */
    public void setMergeType(String mergeType){
        this.mergeType = mergeType;
    }
    
    /**
     * Returns the merge type for the item
     */
    public String getMergeType(){
        return mergeType;
    }

    /**
     * Sets the expansion type
     * @throws IllegalArgumentException if not a valid type
     */
    public void setExpansionType(int type) {
	if (type < DEFAULT_EXPANSION || type > EXPAND) {
	    throw new IllegalArgumentException("Invalid expansion type");
	}
	expand = type;
    }

    /**
     * Returns the exansion type
     */
    public int getExpansionType() {
	return expand;
    }

    /**
     * Sets the presentation
     * @see Presentation
     */
    public void setPresentation(String presentation) {
	this.presentation = presentation;
    }

    /**
     * Returns the presentation
     * @see Presentation
     */
    public String getPresentation() {
	return presentation;
    }

    /**
     * Sets the presentation name
     * @see Presentation
     */
    public void setPresentationName(String presentationName) {
	this.presentationName = presentationName;
    }

    /**
     * Returns the presentation name
     * @see Presentation
     */
    public String getPresentationName() {
	return presentationName;
    }

    /**
     * Returns a String used when displaying the object.
     * Used by CellRenderers.
     *
     * @see TOCCellRenderer
     */
    public String toString() {
	return (id+"("+name+")");
    }

    // for serialization
     private void writeObject(java.io.ObjectOutputStream out) throws IOException {
         //ignore so that FavoritesItem will work
     }
     
     private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
         //ignore so that FavoritesItem will work
     }
 

}

