/* 
 * @(#) UniteAppendMerge.java 1.7 - last change made 08/21/03
 * 
 *
 *  Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import java.util.Locale;
/**
 * Unite-append merge type
 *
 * @author Richard Gregor
 * @version 	1.7	08/21/03
 */

public class UniteAppendMerge extends Merge{

    /**
     * Constructs UniteAppendMerge
     *
     * @param master The master NavigatorView
     * @param slave The slave NavigatorView
     */
    public UniteAppendMerge(NavigatorView master, NavigatorView slave) {
        super(master, slave);
    }
    
    /**
     * Processes unite-append merge 
     *
     * @param node The master node
     * @return Merged master node
     */
    public TreeNode processMerge(TreeNode node) {
        
	DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode) node;
        
        //if master and slave are the same object return the
	// masterNode 
        if (masterNode.equals(slaveTopNode)) {
            return masterNode;
        }
        
	// If there are not children in slaveTopNode return the
	// masterNode
        if (slaveTopNode.getChildCount() == 0) { 
            return masterNode;
        }
        
	mergeNodes(masterNode, slaveTopNode);
        return masterNode;
    }
    
    
    /**
     * Merge Nodes. Merge two nodes according to the UniteAppend merging rules 
     *
     * @param masterNode The master node to merge with 
     * @param slaveNode The node to merge into the master
     */
    public static void mergeNodes(TreeNode master, TreeNode slave) {
       DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)master;
       DefaultMutableTreeNode slaveNode = (DefaultMutableTreeNode)slave;
       debug("mergeNodes master=" + MergeHelpUtilities.getNodeName(masterNode) + 
	     " slave=" + MergeHelpUtilities.getNodeName(slaveNode));       


       int masterCnt = masterNode.getChildCount();

       // loop thru the slaves
       while (slaveNode.getChildCount() > 0) {
	    DefaultMutableTreeNode slaveNodeChild = 
		(DefaultMutableTreeNode)slaveNode.getFirstChild();
	    
	    //loop thru the master children
	    for (int m=0; m < masterCnt; m++) {
		DefaultMutableTreeNode masterAtM = 
		    (DefaultMutableTreeNode)masterNode.getChildAt(m);
		
		// see if the names are the same
		if (MergeHelpUtilities.compareNames(masterAtM, 
						    slaveNodeChild) == 0) {
		    // See if the IDs are the same
		    if (MergeHelpUtilities.haveEqualID(masterAtM,
							  slaveNodeChild)) {
			// ID and name the same merge the slave node in
			MergeHelpUtilities.mergeNodes("javax.help.UniteAppendMerge",
						      masterAtM,
						      slaveNodeChild);
			// Need to remove the slaveNodeChild from the list
			slaveNodeChild.removeFromParent();
			slaveNodeChild = null;
			break;
		    } else {
			// Names are the same but the ID are not
			// Mark the nodes and add the slaveChild
			MergeHelpUtilities.markNodes(masterAtM, 
						     slaveNodeChild);
			masterNode.add(slaveNodeChild);
			MergeHelpUtilities.mergeNodeChildren("javax.help.UniteAppendMerge",
							     slaveNodeChild);
			slaveNodeChild = null;
			break;
		    }
		}
	    }
	    if (slaveNodeChild != null) {
		masterNode.add(slaveNodeChild);
		MergeHelpUtilities.mergeNodeChildren("javax.help.UniteAppendMerge",
						     slaveNodeChild);
	    }
       }
       // There are no more children.
       // Remove slaveNode from it's parent
       slaveNode.removeFromParent();
       slaveNode = null;
    }

    /**
     * Merge Node Children. Merge the children of a node according to the
     * UniteAppend merging.
     *
     * @param node The parent node from which the children are merged
     */
    public static void mergeNodeChildren(TreeNode node) {
	DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)node;
	debug("mergeNodes master=" + MergeHelpUtilities.getNodeName(masterNode));
	
	
	// The rules are there are no rules. Nothing else needs to be done
	// except for merging through the children
	for (int i=0; i < masterNode.getChildCount(); i++) {
	    DefaultMutableTreeNode child = 
		(DefaultMutableTreeNode)masterNode.getChildAt(i);
	    if (!child.isLeaf()) {
		MergeHelpUtilities.mergeNodeChildren("javax.help.UniteAppendMerge", child);
	    }
	}
    }

    private static boolean debug = false;
    private static void debug(String msg) {
        if (debug) {
            System.out.println("UniteAppendMerge :"+msg);
	}
    }
     
}
