/*
 * @(#) HelpHistoryModelEvent.java 1.3 - last change made 10/08/01
 *
 * Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help.event;

/**
 * Notifies interested parties that a change in a
 * Help History Model source has occurred.
 *
 * @author  Richard Gregor
 * @version   1.3     10/08/01
 */

public class HelpHistoryModelEvent extends java.util.EventObject{

    private boolean next;
    private boolean previous;    
    
    /**
     * Represents a history change 
     *
     * @param source The source for this event.
     * @param previous If true a previous action is allowed.
     * @param next If true a next action is allowed.
     * @throws IllegalArgumentException if source is null.
     */
    public HelpHistoryModelEvent(Object source, boolean previous, 
				 boolean next) {
        super(source);
        this.next = next;
        this.previous = previous;        
    }
    
    /**
     * Returns if action "previous" is allowed.
     * 
     * @return True if action is allowed, false otherwise. 
     */
    public boolean isPrevious(){
        return previous;
    }
    
    /**
     * Returns if action "next" is allowed
     *
     * @return True if action is allowed, false otherwise.
     */
    public boolean isNext() {
        return next;
    }
    
}
