/*
 * @(#) NavigatorsTag.java 1.3 - last change made 03/03/03
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help.tagext;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.servlet.ServletRequest;
import java.util.*;
import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.Map.ID;
import javax.help.NavigatorView;

/**
 * The JSP tag class for a Navigators
 *
 * @author Roger D. Brinkley
 * @version	1.3	03/03/03
 * @see javax.help.HelpSet.getNavigatorView()
 * @see javax.help.NavigatorView
 */

public class NavigatorsTag extends BodyTagSupport {
    private HelpBroker hb;
    private HelpSet hs;
    private String curNav = null;
    private NavigatorView[] views;
    private int i;

    public void setHelpBroker(HelpBroker hb) {
	this.hb = hb;
	hs = hb.getHelpSet();
    }

    public void setCurrentNav(String nav) {
	curNav = nav;
    }

    public void initialize() {
	checkRequestParams();
	initCurNav();
	views = hs.getNavigatorViews();
    }

    public int doStartTag() {
	initialize();
	if(views.length > 0) {
	    i = 0;
	    setNavigatorAttributes(views[i++]);
	    return EVAL_BODY_TAG;
	} else {
	    return SKIP_BODY;
	}
    }

    private void checkRequestParams() {
	ServletRequest request = pageContext.getRequest();

	String nav = request.getParameter("nav");
	if (nav != null) {
	    curNav = nav;
	}

    }

    private void initCurNav() {
	if (curNav != null) {
	    try {
		hb.setCurrentView(curNav);
	    } catch (IllegalArgumentException e) {
		// Ignore
	    }   
	} else {
	    curNav = hb.getCurrentView();
	}
    }


    public int doAfterBody() throws JspException {
	BodyContent body = getBodyContent();
	try {
	    body.writeOut(getPreviousOut());
	} catch (IOException e) {
	    throw new JspTagException("NavigatorsTag: " + e.getMessage());
	}

	// clear up so the next time the body content is empty
	body.clearBody();
	if (i < views.length) {
	    setNavigatorAttributes(views[i++]);
	    return EVAL_BODY_TAG;
	} else {
	    return SKIP_BODY;
	}
    }

    private void setNavigatorAttributes(NavigatorView view) {
	pageContext.setAttribute("className", view.getClass().getName());
	pageContext.setAttribute("name", view.getName());
	pageContext.setAttribute("tip", view.getLabel());
	String icon = getIconURL(view);
	pageContext.setAttribute("iconURL", icon);
	pageContext.setAttribute("isCurrentNav", new Boolean(curNav.compareTo(view.getName()) == 0));
    }

    /**
     * return the icon URL in String form for a given TOCItem
     * 
     * returns empty String if no content exists.
     */
    private String getIconURL(NavigatorView view) {
	URL url = null;
	ID id = view.getImageID();
	if (id != null) {
	    HelpSet hs = id.hs;
	    Map map = hs.getLocalMap();
	    try {
		url = map.getURLFromID(id);
	    } catch (MalformedURLException e) {
		// just ignore
	    }
	}
	if (url == null) {
	    return "";
	}
	return url.toExternalForm();
    }
}

