/*
 * @(#) TOCItemTag.java 1.4 - last change made 08/21/03
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help.tagext;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.util.*;
import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.Map.ID;
import javax.help.Merge;
import javax.help.MergeHelpUtilities;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.SortMerge;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/**
 * The JSP tag extra info class for an TocItem
 *
 * @author Roger D. Brinkley
 * @version	1.4	08/21/03
 * @see javax.help.TOCItem
 */

public class TOCItemTag extends BodyTagSupport {
    private Enumeration treeEnum;
    private DefaultMutableTreeNode topNode;
    private String baseID="root";
    private HelpBroker hb;
    private TOCView view=null;

    public void setTocView(TOCView view) {
	this.view = view;
    }

    public void setBaseID(String baseID) {
	this.baseID = baseID;
    }

    public void setHelpBroker(HelpBroker hb) {
	this.hb = hb;
    }

    private void initialize() {
	if (view == null) {
	    return;
	}
	topNode = view.getDataAsTree();

	String mergeType = view.getMergeType();
	HelpSet hs = view.getHelpSet();
        Locale locale = hs.getLocale();


	// Make sure the children are all handled correctly
	MergeHelpUtilities.mergeNodeChildren(mergeType, topNode);
        
	// add all the subhelpsets
        addSubHelpSets(hs);

	treeEnum = topNode.preorderEnumeration();
    }

    /** Adds subhelpsets
     *
     * @param hs The HelpSet which subhelpsets will be added
     */
    private void addSubHelpSets(HelpSet hs){
        for( Enumeration e = hs.getHelpSets(); e.hasMoreElements(); ) {
	    HelpSet ehs = (HelpSet) e.nextElement();
	    if (ehs == null) {
		continue;
	    }
            // merge views
            NavigatorView[] views = ehs.getNavigatorViews();
            for(int i = 0; i < views.length; i++){
		if (views[i] instanceof TOCView) {
		    Merge mergeObject = 
			Merge.DefaultMergeFactory.getMerge(view, views[i]);
		    if (mergeObject != null) {
			mergeObject.processMerge(topNode);
		    }
		}
            }
            addSubHelpSets( ehs );
	}
    }    

    public int doStartTag() {
	initialize();
	if(treeEnum.hasMoreElements()) {
	    DefaultMutableTreeNode node = 
		(DefaultMutableTreeNode) treeEnum.nextElement();
	    // never use the top node. It is just the container node
 	    if (node == topNode) {
		try {
		    node = (DefaultMutableTreeNode) treeEnum.nextElement();
		} catch (NoSuchElementException e) {
		    return SKIP_BODY;
		}
	    }
	    setNodeAttributes(node);
	    return EVAL_BODY_TAG;
	}
	else {
	    return SKIP_BODY;
	}
    }

    public int doAfterBody() throws JspException {
	BodyContent body = getBodyContent();
	try {
	    body.writeOut(getPreviousOut());
	} catch (IOException e) {
	    throw new JspTagException("TOCItemTag: " + e.getMessage());
	}

	// clear up so the next time the body content is empty
	body.clearBody();
	if (treeEnum.hasMoreElements()) {
	    DefaultMutableTreeNode node = 
		(DefaultMutableTreeNode) treeEnum.nextElement();
	    setNodeAttributes(node);
	    return EVAL_BODY_TAG;
	} else {
	    return SKIP_BODY;
	}
    }

    private void setNodeAttributes(DefaultMutableTreeNode node) {
	TOCItem item = (TOCItem) node.getUserObject();
	pageContext.setAttribute("name", item.getName());
	String helpID = "";
	if (item.getID() != null) {
	    helpID = item.getID().id;
	}
	pageContext.setAttribute("helpID", helpID);
	pageContext.setAttribute("parent", Integer.toHexString(node.getParent().hashCode()));
	String id = getID(node.getParent());
	pageContext.setAttribute("parentID", id);
	pageContext.setAttribute("node", Integer.toHexString(node.hashCode()));
	id = getID(node);
	pageContext.setAttribute("nodeID", id);
	String content = getContentURL(item);
	pageContext.setAttribute("contentURL", content);
	String icon = getIconURL(node, item, true);
	pageContext.setAttribute("iconURL", icon);
	String iconOpen = getIconURL(node, item, false);
	pageContext.setAttribute("iconOpenURL", iconOpen);
	String expansionType = Integer.toString(item.getExpansionType());
	pageContext.setAttribute("expansionType", expansionType);
    }

    private String getID(TreeNode node) {
	if (node == topNode) {
	    return baseID;
	}
	TreeNode parent = node.getParent();
	if (parent == null) {
	    return "";
	}
	String id = getID(parent);
        id = id.concat("_" + Integer.toString(parent.getIndex(node)));
	return id;
    }

    /**
     * return the content URL in String form for a given TOCItem
     * 
     * returns an empty String if no content exists.
     */
    private String getContentURL(TOCItem item) {
	URL url = null;
	ID id = item.getID();
	if (id != null) {
	    HelpSet hs = id.hs;
	    Map map = hs.getLocalMap();
	    try {
		url = map.getURLFromID(id);
	    } catch (MalformedURLException e) {
		// just ignore
	    }
	}
	if (url == null) {
	    return "";
	}
	return url.toExternalForm();
    }

    /**
     * return the icon URL in String form for a given TOCItem
     * 
     * returns empty String if no content exists.
     */
    private String getIconURL(DefaultMutableTreeNode node,
			      TOCItem item, 
			      boolean closedIcon) {
	URL url = null;
	ID id = item.getImageID();
	if (id == null) {
	    if (node.isLeaf()) {
		id = view.getTopicImageID();
	    } else {
		if (closedIcon) {
		    id = view.getCategoryClosedImageID();
		} else {
		    id = view.getCategoryOpenImageID();
		}
	    }
	}
	if (id != null) {
	    HelpSet hs = id.hs;
	    Map map = hs.getLocalMap();
	    try {
		url = map.getURLFromID(id);
	    } catch (MalformedURLException e) {
		// just ignore
	    }
	}
	if (url == null) {
	    return "";
	}
	return url.toExternalForm();
    }
}

