/*
 * @(#) ValidateTag.java 1.2 - last change made 03/05/03
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help.tagext;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletRequest;
import javax.servlet.ServletException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.InvalidHelpSetContextException;

/**
 * Validates a HelpSet file and an Map.ID thourgh either a Request Parameter
 * or passed as a JSP argument and sets the state in a HelpBroker. Additionally
 * allows a HelpSet to be merged with the current HelpSet in the HelpBroker.
 *
 * @author Roger D. BRinkley
 * @version	1.2	03/05/03
 * @see javax.help.HelpSet
 * @see javax.help.Map.ID
 * @see javax.help.HelpBroker
 */

public class ValidateTag extends TagSupport {
    private HelpBroker helpBroker;
    private String invalidURLPath = "invalidhelp.html";
    private String hsName = null;
    private String id = null;
    private boolean merge = false;

    public void setHelpBroker(HelpBroker helpBroker) {
	this.helpBroker = helpBroker;
    }

    public void setInvalidURL(String relativeURLPath) {
	this.invalidURLPath = relativeURLPath;
    }

    public void setHelpSetName(String hsName) {
	this.hsName = hsName;
    }

    public void setCurrentID(String id) {
	this.id = id;
    }

    public void setMerge(boolean merge) {
	this.merge = merge;
    }

    public int doStartTag() {
	checkRequestParams();
	validateHelpSet();
	validateID();
	return SKIP_BODY;
    }

    private void checkRequestParams() {
	ServletRequest request = pageContext.getRequest();

	if (hsName == null) {
	    hsName = request.getParameter("helpset");
	}

	if (id == null) {
	    id = request.getParameter("id");
	}
    }

    private void validateHelpSet() {
	HelpSet tesths = helpBroker.getHelpSet();

	// If there is already a HelpSet and there isn't a hsName
	// return. Nothing to do
	if (tesths != null && hsName == null) {
	    return;
	}

	// If there isn't a HelpSet and there isn't a hsName
	// then forward to the invalid page
	if (tesths == null && hsName == null) {
	    try {
		pageContext.forward(invalidURLPath);
	    } catch (Exception e) {
		// ignore it
		return;
	    }
	} 


	// If we don't have a helpset and there is a hsName
	// the create one and set the HelpBroker to this page
	if (tesths == null && hsName != null) {
	    helpBroker.setHelpSet(createHelpSet());
	    return;
	} 

	// If we have a helpset and there is a hsname
	// and merging is turned on, merge the helpset
	if (tesths != null && hsName != null && merge) {
	    tesths.add(createHelpSet());
	}
    }

    private HelpSet createHelpSet() {
	HelpSet hs = null;
	ServletRequest request = pageContext.getRequest();
	if (!hsName.startsWith("/")) {
	    hsName = "/" + hsName;
	}
	URL url = null;
	try {
	    if (hsName.startsWith("http")) {
		url = new URL (hsName);
	    } else {
		url = new URL(request.getScheme(),
			      request.getServerName(),
			      request.getServerPort(),
			      hsName);
	    }
	    hs = new HelpSet(null, url);
	} catch (MalformedURLException e) {
	    // ignore
	} catch (HelpSetException hse) {
	    // this is a serious error
	    throw new RuntimeException(hse.getMessage());
	}
	return hs;
    }

    private void validateID() {
	if (id != null) {
	    helpBroker.setCurrentID(id);
	} else if (helpBroker.getCurrentID() == null && 
		   helpBroker.getCurrentURL() == null) {
	    try {
		helpBroker.setCurrentID(helpBroker.getHelpSet().getHomeID());
	    } catch (InvalidHelpSetContextException e) {
		// ignore
	    }
	}
    }
}

