/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.util.Enumeration;
import org.jfree.base.AbstractBoot;
import org.jfree.base.BootableProjectInfo;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.base.config.PropertyFileConfiguration;
import org.jfree.base.config.SystemPropertyConfiguration;
import org.jfree.base.log.DefaultLog;
import org.jfree.base.modules.PackageManager;
import org.jfree.report.JFreeReportInfo;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class JFreeReportBoot
extends AbstractBoot {
    private static JFreeReportBoot instance;
    private BootableProjectInfo projectInfo = new JFreeReportInfo();
    private static transient UserConfigWrapper configWrapper;
    static /* synthetic */ Class class$org$jfree$report$JFreeReportCoreModule;
    static /* synthetic */ Class class$org$jfree$report$DefaultLogModule;

    static {
        configWrapper = new UserConfigWrapper();
    }

    private JFreeReportBoot() {
    }

    private void bootAdditionalModules() {
        try {
            String bootModules = this.getGlobalConfig().getConfigProperty("org.jfree.report.boot.Modules");
            if (bootModules != null) {
                CSVTokenizer csvToken = new CSVTokenizer(bootModules, ",");
                while (csvToken.hasMoreTokens()) {
                    String token = csvToken.nextToken();
                    this.getPackageManager().load(token);
                }
            }
        }
        catch (SecurityException securityException) {
            Log.info((Object)"Security settings forbid to check the system properties for extension modules.");
        }
        catch (Exception se) {
            Log.error((Object)"An error occured while checking the system properties for extension modules.", (Exception)se);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ModifiableConfiguration getEditableConfig() {
        return (ModifiableConfiguration)this.getGlobalConfig();
    }

    public static synchronized JFreeReportBoot getInstance() {
        if (instance == null) {
            DefaultLog.getDefaultLog();
            instance = new JFreeReportBoot();
        }
        return instance;
    }

    protected BootableProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public static Configuration getUserConfig() {
        return configWrapper.getWrappedConfiguration();
    }

    private static boolean isStrictFP() {
        double d = 8.0E307;
        double result1 = Double.POSITIVE_INFINITY;
        double result2 = 1.6E308;
        return true;
    }

    protected Configuration loadConfiguration() {
        HierarchicalConfiguration globalConfig = new HierarchicalConfiguration();
        PropertyFileConfiguration rootProperty = new PropertyFileConfiguration();
        rootProperty.load("/org/jfree/report/jfreereport.properties");
        rootProperty.load("/org/jfree/report/ext/jfreereport-ext.properties");
        globalConfig.insertConfiguration((HierarchicalConfiguration)rootProperty);
        globalConfig.insertConfiguration((HierarchicalConfiguration)JFreeReportBoot.getInstance().getPackageManager().getPackageConfiguration());
        PropertyFileConfiguration baseProperty = new PropertyFileConfiguration();
        baseProperty.load("/jfreereport.properties");
        globalConfig.insertConfiguration((HierarchicalConfiguration)baseProperty);
        globalConfig.insertConfiguration((HierarchicalConfiguration)configWrapper);
        SystemPropertyConfiguration systemConfig = new SystemPropertyConfiguration();
        globalConfig.insertConfiguration((HierarchicalConfiguration)systemConfig);
        return globalConfig;
    }

    protected void performBoot() {
        if (!JFreeReportBoot.isStrictFP()) {
            Log.warn((Object)"The used VM seems to use a non-strict floating point arithmetics");
            Log.warn((Object)"Layouts computed with this Java Virtual Maschine may be invalid.");
            Log.warn((Object)"JFreeReport and the library 'iText' depend on the strict floating point rules");
            Log.warn((Object)"of Java1.1 as implemented by the Sun Virtual Maschines.");
            Log.warn((Object)"If you are using the BEA JRockit VM, start the Java VM with the option");
            Log.warn((Object)"'-Xstrictfp' to restore the default behaviour.");
        }
        PackageManager mgr = this.getPackageManager();
        mgr.addModule((class$org$jfree$report$JFreeReportCoreModule != null ? class$org$jfree$report$JFreeReportCoreModule : (class$org$jfree$report$JFreeReportCoreModule = JFreeReportBoot.class$("org.jfree.report.JFreeReportCoreModule"))).getName());
        mgr.addModule((class$org$jfree$report$DefaultLogModule != null ? class$org$jfree$report$DefaultLogModule : (class$org$jfree$report$DefaultLogModule = JFreeReportBoot.class$("org.jfree.report.DefaultLogModule"))).getName());
        mgr.load("org.jfree.report.modules.");
        mgr.load("org.jfree.report.ext.modules.");
        mgr.load("org.jfree.report.userdefined.modules.");
        this.bootAdditionalModules();
        mgr.initializeModules();
    }

    public static void setUserConfig(Configuration config) {
        configWrapper.setWrappedConfiguration(config);
    }

    private static class UserConfigWrapper
    extends HierarchicalConfiguration
    implements Configuration {
        private Configuration wrappedConfiguration;

        public Enumeration getConfigProperties() {
            if (this.wrappedConfiguration instanceof ModifiableConfiguration) {
                ModifiableConfiguration modConfiguration = (ModifiableConfiguration)this.wrappedConfiguration;
                return modConfiguration.getConfigProperties();
            }
            return super.getConfigProperties();
        }

        public String getConfigProperty(String key) {
            if (this.wrappedConfiguration == null) {
                return this.getParentConfig().getConfigProperty(key);
            }
            String retval = this.wrappedConfiguration.getConfigProperty(key);
            if (retval != null) {
                return retval;
            }
            return this.getParentConfig().getConfigProperty(key);
        }

        public String getConfigProperty(String key, String defaultValue) {
            if (this.wrappedConfiguration == null) {
                return this.getParentConfig().getConfigProperty(key, defaultValue);
            }
            String retval = this.wrappedConfiguration.getConfigProperty(key, null);
            if (retval != null) {
                return retval;
            }
            return this.getParentConfig().getConfigProperty(key, defaultValue);
        }

        public Configuration getWrappedConfiguration() {
            return this.wrappedConfiguration;
        }

        public void setConfigProperty(String key, String value) {
            if (this.wrappedConfiguration instanceof ModifiableConfiguration) {
                ModifiableConfiguration modConfiguration = (ModifiableConfiguration)this.wrappedConfiguration;
                modConfiguration.setConfigProperty(key, value);
            }
        }

        public void setWrappedConfiguration(Configuration wrappedConfiguration) {
            this.wrappedConfiguration = wrappedConfiguration;
        }
    }
}

