/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import org.jfree.report.Element;
import org.jfree.report.ImageContainer;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentFactoryModule;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.content.ImageContent;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.StringUtil;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.report.util.geom.StrictPoint;

public strictfp class ImageContentFactoryModule
implements ContentFactoryModule {
    public boolean canHandleContent(String contentType) {
        return StringUtil.startsWithIgnoreCase(contentType, "image/");
    }

    public Content createContentForElement(Element e, ElementLayoutInformation bounds, LayoutSupport ot) {
        StrictBounds imageBounds;
        ImageContainer ir = (ImageContainer)e.getValue();
        if (ir == null) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictPoint point = bounds.getAbsolutePosition();
        StrictDimension iBounds = ElementLayoutInformation.unionMin(bounds.getMaximumSize(), bounds.getPreferredSize());
        if (iBounds.getWidth() == 0L || iBounds.getHeight() == 0L) {
            return EmptyContent.getDefaultEmptyContent();
        }
        double scaleX = ir.getScaleX();
        double scaleY = ir.getScaleY();
        long w = StrictGeomUtility.toInternalValue(ir.getImageWidth());
        long h = StrictGeomUtility.toInternalValue(ir.getImageHeight());
        if (w == 0L || h == 0L) {
            return EmptyContent.getDefaultEmptyContent();
        }
        if (e.getStyle().getBooleanStyleProperty(ElementStyleSheet.SCALE)) {
            scaleX = (double)iBounds.getWidth() / (double)w;
            scaleY = (double)iBounds.getHeight() / (double)h;
            if ((scaleX != 1.0 || scaleY != 1.0) && e.getStyle().getBooleanStyleProperty(ElementStyleSheet.KEEP_ASPECT_RATIO)) {
                float scale = (float)Math.min(scaleX, scaleY);
                scaleX = scale;
                scaleY = scale;
            }
        }
        if ((imageBounds = new StrictBounds(point.getX(), point.getY(), (long)(scaleX * (double)w), (long)(scaleY * (double)h))).getWidth() == 0L || imageBounds.getHeight() == 0L) {
            return EmptyContent.getDefaultEmptyContent();
        }
        ImageContent ic = new ImageContent(ir, imageBounds);
        return ic;
    }
}

