/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.ElementAlignment;
import org.jfree.report.TextElement;
import org.jfree.report.elementfactory.TextFieldElementFactory;
import org.jfree.report.filter.templates.ResourceFieldTemplate;
import org.jfree.report.style.FontDefinition;
import org.jfree.ui.FloatDimension;

public class ResourceFieldElementFactory
extends TextFieldElementFactory {
    private String resourceBase;

    public Element createElement() {
        if (this.getFieldname() == null) {
            throw new IllegalStateException("Fieldname is not set.");
        }
        ResourceFieldTemplate template = new ResourceFieldTemplate();
        template.setResourceIdentifier(this.getResourceBase());
        template.setField(this.getFieldname());
        template.setNullValue(this.getNullString());
        TextElement element = new TextElement();
        this.applyElementName(element);
        element.setDataSource(template);
        this.applyStyle(element.getStyle());
        return element;
    }

    public static TextElement createResourceElement(String name, Rectangle2D bounds, Color color, ElementAlignment alignment, ElementAlignment valignment, FontDefinition font, String nullValue, String resourceBase, String field) {
        ResourceFieldElementFactory factory = new ResourceFieldElementFactory();
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setName(name);
        factory.setColor(color);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valignment);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(new Boolean(font.isBold()));
            factory.setItalic(new Boolean(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(new Boolean(font.isUnderline()));
            factory.setStrikethrough(new Boolean(font.isStrikeThrough()));
            factory.setEmbedFont(new Boolean(font.isEmbeddedFont()));
        }
        factory.setNullString(nullValue);
        factory.setResourceBase(resourceBase);
        factory.setFieldname(field);
        return (TextElement)factory.createElement();
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }
}

