/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Locale;
import org.jfree.report.ReportDefinition;
import org.jfree.report.filter.NumberFormatParser;
import org.jfree.report.filter.ReportConnectable;

public class DecimalFormatParser
extends NumberFormatParser
implements ReportConnectable {
    private ReportDefinition reportDefinition;
    private Locale lastLocale;
    private boolean keepState;

    public DecimalFormatParser() {
        this.setFormatter(new DecimalFormat());
    }

    public DecimalFormat getDecimalFormat() {
        return (DecimalFormat)this.getFormatter();
    }

    public String getFormatString() {
        return this.getDecimalFormat().toPattern();
    }

    public String getLocalizedFormatString() {
        return this.getDecimalFormat().toLocalizedPattern();
    }

    public Object getValue() {
        Locale locale;
        if (!this.keepState && this.reportDefinition != null && (locale = this.reportDefinition.getResourceBundleFactory().getLocale()) != this.lastLocale) {
            this.lastLocale = locale;
            this.getDecimalFormat().setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
        }
        return super.getValue();
    }

    public boolean isKeepState() {
        return this.keepState;
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != null) {
            throw new IllegalStateException("Already connected.");
        }
        if (reportDefinition == null) {
            throw new NullPointerException("The given report definition is null");
        }
        this.reportDefinition = reportDefinition;
    }

    public void setDecimalFormat(DecimalFormat format) {
        this.setFormatter(format);
    }

    public void setFormatString(String format) {
        this.getDecimalFormat().applyPattern(format);
    }

    public void setFormatter(Format format) {
        DecimalFormat dfmt = (DecimalFormat)format;
        super.setFormatter(dfmt);
    }

    public void setKeepState(boolean keepState) {
        this.keepState = keepState;
    }

    public void setLocalizedFormatString(String format) {
        this.getDecimalFormat().applyLocalizedPattern(format);
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != reportDefinition) {
            throw new IllegalStateException("This report definition is not registered.");
        }
        this.reportDefinition = null;
    }
}

