/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import org.jfree.report.DefaultImageReference;
import org.jfree.report.ImageContainer;
import org.jfree.report.filter.DataFilter;
import org.jfree.report.filter.DataSource;
import org.jfree.util.Log;

public class ImageRefFilter
implements DataFilter,
Serializable {
    private DataSource dataSource;

    public Object clone() throws CloneNotSupportedException {
        ImageRefFilter r = (ImageRefFilter)super.clone();
        if (this.dataSource != null) {
            r.dataSource = (DataSource)this.dataSource.clone();
        }
        return r;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Object getValue() {
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return null;
        }
        Object o = ds.getValue();
        if (o instanceof ImageContainer) {
            return o;
        }
        if (o == null || !(o instanceof Image)) {
            return null;
        }
        try {
            return new DefaultImageReference((Image)o);
        }
        catch (IOException e) {
            Log.warn((Object)"Unable to fully load a given image.", (Exception)e);
            return null;
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

