/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.jfree.report.DataRow;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.PropertyLookupParser;

public class MessageFormatSupport
implements Serializable {
    private String[] fields;
    private MessageFormat format;
    private String formatString;
    private String compiledFormat;

    public String getCompiledFormat() {
        return this.compiledFormat;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public Locale getLocale() {
        return this.format.getLocale();
    }

    public String performFormat(DataRow dataRow) {
        if (this.fields == null || this.format == null) {
            return null;
        }
        Object[] parameters = new Object[this.fields.length];
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = dataRow.get(this.fields[i]);
            ++i;
        }
        return this.format.format(parameters);
    }

    public void setFormatString(String formatString) {
        MessageCompiler compiler = new MessageCompiler();
        if (formatString == null) {
            throw new NullPointerException("Format must not be null");
        }
        this.compiledFormat = compiler.translateAndLookup(formatString);
        this.fields = compiler.getFields();
        this.format = new MessageFormat(this.compiledFormat);
        this.formatString = formatString;
    }

    public void setLocale(Locale locale) {
        this.format.setLocale(locale);
        this.format.applyPattern(this.compiledFormat);
    }

    protected static class MessageCompiler
    extends PropertyLookupParser {
        private ArrayList fields = new ArrayList();
        private ArrayList completeFormatString = new ArrayList();

        public MessageCompiler() {
            this.setMarkerChar('$');
            this.setOpeningBraceChar('(');
            this.setClosingBraceChar(')');
        }

        public String[] getFields() {
            return this.fields.toArray(new String[this.fields.size()]);
        }

        protected String lookupVariable(String name) {
            CSVTokenizer tokenizer = new CSVTokenizer(name, ",", "\"");
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            String varName = tokenizer.nextToken();
            int index = this.fields.indexOf(varName);
            if (index != -1) {
                return (String)this.completeFormatString.get(index);
            }
            StringBuffer b = new StringBuffer();
            b.append("{");
            b.append(String.valueOf(this.fields.size()));
            while (tokenizer.hasMoreTokens()) {
                b.append(",");
                b.append(tokenizer.nextToken());
            }
            b.append("}");
            String formatString = b.toString();
            this.completeFormatString.add(formatString);
            this.fields.add(varName);
            return formatString;
        }
    }
}

