/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.Serializable;
import java.util.ResourceBundle;
import org.jfree.report.ReportDefinition;
import org.jfree.report.filter.DataFilter;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.ReportConnectable;
import org.jfree.util.Log;

public class ResourceFileFilter
implements DataFilter,
Serializable,
ReportConnectable {
    private String resourceIdentifier;
    private DataSource dataSource;
    private transient ReportDefinition reportDefinition;

    public Object clone() throws CloneNotSupportedException {
        ResourceFileFilter filter = (ResourceFileFilter)super.clone();
        filter.dataSource = (DataSource)this.dataSource.clone();
        filter.reportDefinition = null;
        return filter;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public Object getValue() {
        if (this.dataSource == null) {
            return null;
        }
        if (this.reportDefinition == null) {
            return null;
        }
        Object value = this.dataSource.getValue();
        if (value == null) {
            return null;
        }
        String svalue = String.valueOf(value);
        try {
            String resourceId = this.resourceIdentifier != null ? this.resourceIdentifier : this.reportDefinition.getReportConfiguration().getConfigProperty("org.jfree.report.ResourceBundle");
            ResourceBundle bundle = this.reportDefinition.getResourceBundle(resourceId);
            if (bundle != null) {
                return bundle.getObject(svalue);
            }
        }
        catch (Exception e) {
            Log.info((Object)new Log.SimpleMessage("Failed to retrive the value for key", (Object)svalue), (Exception)e);
        }
        return null;
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != null) {
            throw new IllegalStateException("Already connected.");
        }
        if (reportDefinition == null) {
            throw new NullPointerException("The given report definition is null");
        }
        this.reportDefinition = reportDefinition;
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public void setResourceIdentifier(String resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != reportDefinition) {
            throw new IllegalStateException("This report definition is not registered.");
        }
        this.reportDefinition = null;
    }
}

