/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter.templates;

import java.text.SimpleDateFormat;
import org.jfree.report.ReportDefinition;
import org.jfree.report.filter.DataRowDataSource;
import org.jfree.report.filter.RawDataSource;
import org.jfree.report.filter.ReportConnectable;
import org.jfree.report.filter.SimpleDateFormatFilter;
import org.jfree.report.filter.StringFilter;
import org.jfree.report.filter.templates.AbstractTemplate;

public class DateFieldTemplate
extends AbstractTemplate
implements ReportConnectable,
RawDataSource {
    private SimpleDateFormatFilter dateFilter;
    private DataRowDataSource dataRowDataSource = new DataRowDataSource();
    private StringFilter stringFilter;

    public DateFieldTemplate() {
        this.dateFilter = new SimpleDateFormatFilter();
        this.dateFilter.setDataSource(this.dataRowDataSource);
        this.stringFilter = new StringFilter();
        this.stringFilter.setDataSource(this.dateFilter);
    }

    public Object clone() throws CloneNotSupportedException {
        DateFieldTemplate template = (DateFieldTemplate)super.clone();
        template.stringFilter = (StringFilter)this.stringFilter.clone();
        template.dateFilter = (SimpleDateFormatFilter)template.stringFilter.getDataSource();
        template.dataRowDataSource = (DataRowDataSource)template.dateFilter.getDataSource();
        return template;
    }

    protected DataRowDataSource getDataRowDataSource() {
        return this.dataRowDataSource;
    }

    protected SimpleDateFormatFilter getDateFilter() {
        return this.dateFilter;
    }

    public SimpleDateFormat getDateFormat() {
        return (SimpleDateFormat)this.getDateFilter().getFormatter();
    }

    public String getField() {
        return this.getDataRowDataSource().getDataSourceColumnName();
    }

    public String getFormat() {
        return this.getDateFilter().getFormatString();
    }

    public String getNullValue() {
        return this.getStringFilter().getNullValue();
    }

    public Object getRawValue() {
        return this.stringFilter.getRawValue();
    }

    protected StringFilter getStringFilter() {
        return this.stringFilter;
    }

    public Object getValue() {
        return this.getStringFilter().getValue();
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        this.getDataRowDataSource().registerReportDefinition(reportDefinition);
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.getDateFilter().setFormatter(dateFormat);
    }

    public void setField(String field) {
        this.getDataRowDataSource().setDataSourceColumnName(field);
    }

    public void setFormat(String format) {
        this.getDateFilter().setFormatString(format);
    }

    public void setNullValue(String nullValue) {
        this.getStringFilter().setNullValue(nullValue);
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        this.getDataRowDataSource().unregisterReportDefinition(reportDefinition);
    }
}

