/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter.templates;

import java.text.DecimalFormat;
import org.jfree.report.ReportDefinition;
import org.jfree.report.filter.DataRowDataSource;
import org.jfree.report.filter.DecimalFormatFilter;
import org.jfree.report.filter.RawDataSource;
import org.jfree.report.filter.ReportConnectable;
import org.jfree.report.filter.StringFilter;
import org.jfree.report.filter.templates.AbstractTemplate;

public class NumberFieldTemplate
extends AbstractTemplate
implements ReportConnectable,
RawDataSource {
    private DecimalFormatFilter decimalFormatFilter;
    private DataRowDataSource dataRowDataSource = new DataRowDataSource();
    private StringFilter stringFilter;

    public NumberFieldTemplate() {
        this.decimalFormatFilter = new DecimalFormatFilter();
        this.decimalFormatFilter.setDataSource(this.dataRowDataSource);
        this.stringFilter = new StringFilter();
        this.stringFilter.setDataSource(this.decimalFormatFilter);
    }

    public Object clone() throws CloneNotSupportedException {
        NumberFieldTemplate template = (NumberFieldTemplate)super.clone();
        template.stringFilter = (StringFilter)this.stringFilter.clone();
        template.decimalFormatFilter = (DecimalFormatFilter)template.stringFilter.getDataSource();
        template.dataRowDataSource = (DataRowDataSource)template.decimalFormatFilter.getDataSource();
        return template;
    }

    protected DataRowDataSource getDataRowDataSource() {
        return this.dataRowDataSource;
    }

    public DecimalFormat getDecimalFormat() {
        return (DecimalFormat)this.decimalFormatFilter.getFormatter();
    }

    public String getField() {
        return this.dataRowDataSource.getDataSourceColumnName();
    }

    public String getFormat() {
        return this.decimalFormatFilter.getFormatString();
    }

    public String getNullValue() {
        return this.stringFilter.getNullValue();
    }

    public Object getRawValue() {
        return this.stringFilter.getRawValue();
    }

    public Object getValue() {
        return this.stringFilter.getValue();
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        this.getDataRowDataSource().registerReportDefinition(reportDefinition);
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormatFilter.setFormatter(decimalFormat);
    }

    public void setField(String field) {
        this.dataRowDataSource.setDataSourceColumnName(field);
    }

    public void setFormat(String format) {
        this.decimalFormatFilter.setFormatString(format);
    }

    public void setNullValue(String nullValue) {
        this.stringFilter.setNullValue(nullValue);
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        this.getDataRowDataSource().unregisterReportDefinition(reportDefinition);
    }
}

