/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.FunctionUtilities;

public class CountDistinctFunction
extends AbstractFunction
implements Serializable {
    private transient HashSet values = new HashSet();
    private String group;
    private String field;

    public String getField() {
        return this.field;
    }

    public String getGroup() {
        return this.group;
    }

    public Object getValue() {
        return new Integer(this.values.size());
    }

    public void groupStarted(ReportEvent event) {
        if (this.getField() == null) {
            return;
        }
        if (!FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            return;
        }
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        this.values.clear();
    }

    public void itemsAdvanced(ReportEvent event) {
        if (this.getField() == null) {
            return;
        }
        if (!FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            return;
        }
        Object o = event.getDataRow().get(this.getField());
        this.values.add(o);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.values = new HashSet();
    }

    public void reportInitialized(ReportEvent event) {
        if (!FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            return;
        }
        this.values.clear();
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setGroup(String name) {
        this.group = name;
    }
}

