/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.text.MessageFormat;
import java.util.Locale;
import org.jfree.report.DataRow;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.Expression;
import org.jfree.report.function.PageFunction;
import org.jfree.report.function.PageTotalFunction;

public class PageOfPagesFunction
extends PageFunction {
    private PageTotalFunction pageTotalFunction = new PageTotalFunction();
    private String format;
    private transient Locale locale;

    public PageOfPagesFunction() {
        this.pageTotalFunction.setName("__internally_used_only");
        this.format = "{0} / {1}";
    }

    public PageOfPagesFunction(String name) {
        this();
        this.setName(name);
    }

    public String getFormat() {
        return this.format;
    }

    public Expression getInstance() {
        PageOfPagesFunction function = (PageOfPagesFunction)super.getInstance();
        function.pageTotalFunction = (PageTotalFunction)this.pageTotalFunction.getInstance();
        return function;
    }

    public Object getValue() {
        Object page = super.getValue();
        Object pages = this.pageTotalFunction.getValue();
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        MessageFormat compiledFormat = new MessageFormat(this.getFormat());
        compiledFormat.setLocale(this.locale);
        compiledFormat.applyPattern(this.getFormat());
        return compiledFormat.format(new Object[]{page, pages});
    }

    public void groupStarted(ReportEvent event) {
        super.groupStarted(event);
        this.pageTotalFunction.groupStarted(event);
        this.locale = event.getReport().getResourceBundleFactory().getLocale();
    }

    public void pageCanceled(ReportEvent event) {
        super.pageCanceled(event);
        this.pageTotalFunction.pageCanceled(event);
        this.locale = event.getReport().getResourceBundleFactory().getLocale();
    }

    public void pageFinished(ReportEvent event) {
        super.pageFinished(event);
        this.pageTotalFunction.pageFinished(event);
        this.locale = event.getReport().getResourceBundleFactory().getLocale();
    }

    public void pageStarted(ReportEvent event) {
        super.pageStarted(event);
        this.pageTotalFunction.pageStarted(event);
        this.locale = event.getReport().getResourceBundleFactory().getLocale();
    }

    public void reportInitialized(ReportEvent event) {
        super.reportInitialized(event);
        this.pageTotalFunction.reportInitialized(event);
        this.locale = event.getReport().getResourceBundleFactory().getLocale();
    }

    public void setDataRow(DataRow dataRow) {
        super.setDataRow(dataRow);
        this.pageTotalFunction.setDataRow(dataRow);
    }

    public void setDependencyLevel(int level) {
        super.setDependencyLevel(level);
        this.pageTotalFunction.setDependencyLevel(level);
    }

    public void setFormat(String format) {
        if (format == null) {
            throw new NullPointerException("Format must not be null.");
        }
        this.format = format;
    }

    public void setGroup(String group) {
        super.setGroup(group);
        this.pageTotalFunction.setGroup(group);
    }

    public void setStartPage(int startPage) {
        super.setStartPage(startPage);
        this.pageTotalFunction.setStartPage(startPage);
    }
}

