/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.layout;

import java.util.HashMap;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.util.Log;

public class LayoutManagerCache {
    private static int putCount;
    private static int getCount;
    private final HashMap elementCache = new HashMap();
    private final HashMap dynamicCache = new HashMap();

    public void flush() {
        this.elementCache.clear();
    }

    public void flushDynamicCache() {
        this.dynamicCache.clear();
    }

    public StrictDimension getMinSize(Object e) {
        ElementCacheCarrier ec = this.lookupCacheEntry(e);
        if (ec == null) {
            return null;
        }
        StrictDimension dim = ec.getMinSize();
        if (dim != null) {
            ++getCount;
            return dim.getUnlockedInstance();
        }
        return null;
    }

    public StrictDimension getPrefSize(Object e) {
        ElementCacheCarrier ec = this.lookupCacheEntry(e);
        if (ec == null) {
            return null;
        }
        StrictDimension dim = ec.getPrefSize();
        if (dim != null) {
            ++getCount;
            return dim.getUnlockedInstance();
        }
        return null;
    }

    public boolean isCachable(Element e) {
        if (!e.getStyle().getBooleanStyleProperty(ElementStyleSheet.ELEMENT_LAYOUT_CACHEABLE)) {
            return false;
        }
        if (e instanceof Band) {
            Element[] elements = ((Band)e).getElementArray();
            int i = 0;
            while (i < elements.length) {
                if (!this.isCachable(elements[i])) {
                    e.getStyle().setBooleanStyleProperty(ElementStyleSheet.ELEMENT_LAYOUT_CACHEABLE, false);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private ElementCacheCarrier lookupCacheEntry(Object e) {
        ElementCacheCarrier staticCacheEntry = (ElementCacheCarrier)this.elementCache.get(e);
        if (staticCacheEntry != null) {
            return staticCacheEntry;
        }
        return (ElementCacheCarrier)this.dynamicCache.get(e);
    }

    public static void printResults() {
        Log.debug((Object)("CacheResults: " + getCount + ":" + putCount + " Ratio: " + (double)getCount / (double)putCount));
    }

    public void setMinSize(Element element, StrictDimension d) {
        if (element == null) {
            throw new NullPointerException("Element is null");
        }
        ++putCount;
        boolean dynamic = element.isDynamicContent();
        ElementCacheCarrier ec = this.lookupCacheEntry(element.getObjectID());
        if (ec == null) {
            ec = new ElementCacheCarrier();
            ec.setMinSize(d.getLockedInstance());
            ec.setDynamic(dynamic);
            if (dynamic) {
                this.dynamicCache.put(element.getObjectID(), ec);
            } else {
                this.elementCache.put(element.getObjectID(), ec);
            }
        } else {
            ec.setMinSize(d.getLockedInstance());
            if (dynamic != ec.isDynamic()) {
                if (dynamic) {
                    this.dynamicCache.put(element.getObjectID(), ec);
                    this.elementCache.remove(element.getObjectID());
                } else {
                    this.elementCache.put(element.getObjectID(), ec);
                    this.dynamicCache.remove(element.getObjectID());
                }
            }
        }
    }

    public void setPrefSize(Element element, StrictDimension d) {
        if (element == null) {
            throw new IllegalArgumentException("LayoutCacheKey: Element is null");
        }
        ++putCount;
        boolean dynamic = element.isDynamicContent();
        ElementCacheCarrier ec = this.lookupCacheEntry(element.getObjectID());
        if (ec == null) {
            ec = new ElementCacheCarrier();
            ec.setPrefSize(d.getLockedInstance());
            ec.setDynamic(dynamic);
            this.elementCache.put(element.getObjectID(), ec);
        } else {
            ec.setPrefSize(d.getLockedInstance());
            if (dynamic != ec.isDynamic()) {
                if (dynamic) {
                    this.dynamicCache.put(element.getObjectID(), ec);
                    this.elementCache.remove(element.getObjectID());
                } else {
                    this.elementCache.put(element.getObjectID(), ec);
                    this.dynamicCache.remove(element.getObjectID());
                }
            }
        }
    }

    private static class ElementCacheCarrier {
        private boolean dynamic;
        private StrictDimension minSize;
        private StrictDimension prefSize;

        public StrictDimension getMinSize() {
            return this.minSize;
        }

        public StrictDimension getPrefSize() {
            return this.prefSize;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public void setDynamic(boolean dynamic) {
            this.dynamic = dynamic;
        }

        public void setMinSize(StrictDimension dimension2D) {
            this.minSize = dimension2D;
        }

        public void setPrefSize(StrictDimension dimension2D) {
            this.prefSize = dimension2D;
        }
    }
}

