/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jfree.report.event.RepaginationListener;
import org.jfree.report.event.RepaginationState;

public class ReportProgressDialog
extends JDialog
implements RepaginationListener {
    private JLabel messageCarrier;
    private JLabel passCountMessage;
    private JLabel pageCountMessage;
    private JLabel rowCountMessage;
    private JProgressBar progressBar;
    private MessageFormat pageMessageFormatter;
    private MessageFormat rowsMessageFormatter;
    private MessageFormat passMessageFormatter;
    private int lastPage;
    private int lastPass;
    private int lastMaxRow;
    private Integer lastMaxRowInteger;
    private String layoutText;
    private String outputText;
    private ResourceBundle resources;

    public ReportProgressDialog() {
        this.initConstructor();
    }

    public ReportProgressDialog(Dialog dialog) {
        super(dialog);
        this.initConstructor();
    }

    public ReportProgressDialog(Frame frame) {
        super(frame);
        this.initConstructor();
    }

    public String getLayoutText() {
        return this.layoutText;
    }

    public String getMessage() {
        return this.messageCarrier.getText();
    }

    public String getOutputText() {
        return this.outputText;
    }

    protected final JLabel getPageCountMessage() {
        return this.pageCountMessage;
    }

    protected final MessageFormat getPageMessageFormatter() {
        return this.pageMessageFormatter;
    }

    protected final JLabel getPassCountMessage() {
        return this.passCountMessage;
    }

    protected final MessageFormat getPassMessageFormatter() {
        return this.passMessageFormatter;
    }

    protected final JLabel getRowCountMessage() {
        return this.rowCountMessage;
    }

    protected final MessageFormat getRowsMessageFormatter() {
        return this.rowsMessageFormatter;
    }

    private void initConstructor() {
        this.resources = ResourceBundle.getBundle("org.jfree.report.modules.gui.base.resources.jfreereport-resources");
        this.initialize();
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                ReportProgressDialog.this.toFront();
            }
        });
        this.setOutputText(this.resources.getString("progress-dialog.perform-output"));
        this.setLayoutText(this.resources.getString("progress-dialog.prepare-layout"));
        this.lastPass = -1;
        this.lastMaxRow = -1;
        this.lastPage = -1;
    }

    private void initialize() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new GridBagLayout());
        this.pageMessageFormatter = new MessageFormat(this.resources.getString("progress-dialog.page-label"));
        this.rowsMessageFormatter = new MessageFormat(this.resources.getString("progress-dialog.rows-label"));
        this.passMessageFormatter = new MessageFormat(this.resources.getString("progress-dialog.pass-label"));
        this.messageCarrier = new JLabel(" ");
        this.passCountMessage = new JLabel(" ");
        this.rowCountMessage = new JLabel(" ");
        this.pageCountMessage = new JLabel(" ");
        this.progressBar = new JProgressBar();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 5, 1);
        gbc.ipadx = 200;
        contentPane.add((Component)this.messageCarrier, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 16;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.passCountMessage, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.progressBar, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.pageCountMessage, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 10, 1, 1);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        contentPane.add((Component)this.rowCountMessage, gbc);
        this.setContentPane(contentPane);
    }

    protected boolean isSameMaxRow(int row) {
        return this.lastMaxRow == row;
    }

    public void repaginationUpdate(RepaginationState state) {
        ScreenUpdateRunnable runnable = new ScreenUpdateRunnable(this.progressBar, state.getCurrentRow(), state.getMaxRow(), state.getPage(), state.getPass(), state.isPrepare());
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setLayoutText(String layoutText) {
        if (layoutText == null) {
            throw new NullPointerException("LayoutText must not be null.");
        }
        this.layoutText = layoutText;
    }

    public void setMessage(String message) {
        this.messageCarrier.setText(message);
    }

    public void setOutputText(String outputText) {
        if (outputText == null) {
            throw new NullPointerException("OutputText must not be null.");
        }
        this.outputText = outputText;
    }

    protected void updatePageMessage(int page) {
        if (this.lastPage != page) {
            Object[] parameters = new Object[]{new Integer(page)};
            this.pageCountMessage.setText(this.pageMessageFormatter.format(parameters));
            this.lastPage = page;
        }
    }

    protected void updatePassMessage(int pass, boolean prepare) {
        if (this.lastPass != pass) {
            this.lastPass = pass;
            if (pass >= 0) {
                Object[] parameters = new Object[]{new Integer(pass)};
                this.passCountMessage.setText(this.passMessageFormatter.format(parameters));
            } else {
                String message = prepare ? this.getLayoutText() : this.getOutputText();
                this.passCountMessage.setText(message);
            }
        }
    }

    protected void updateRowsMessage(int rows, int maxRows) {
        if (maxRows != this.lastMaxRow) {
            this.lastMaxRowInteger = new Integer(maxRows);
            this.lastMaxRow = maxRows;
        }
        Object[] parameters = new Object[]{new Integer(rows), this.lastMaxRowInteger};
        this.rowCountMessage.setText(this.rowsMessageFormatter.format(parameters));
    }

    private class ScreenUpdateRunnable
    implements Runnable {
        private int pass;
        private int page;
        private boolean prepare;
        private int maxRow;
        private int currentRow;
        private JProgressBar progressBar;

        public ScreenUpdateRunnable(JProgressBar progressBar, int currentRow, int maxRow, int page, int pass, boolean prepare) {
            this.progressBar = progressBar;
            this.currentRow = currentRow;
            this.maxRow = maxRow;
            this.page = page;
            this.pass = pass;
            this.prepare = prepare;
        }

        public void run() {
            boolean maxRowSame = ReportProgressDialog.this.isSameMaxRow(this.maxRow);
            ReportProgressDialog.this.updatePageMessage(this.page);
            ReportProgressDialog.this.updatePassMessage(this.pass, this.prepare);
            ReportProgressDialog.this.updateRowsMessage(this.currentRow, this.maxRow);
            if (!maxRowSame) {
                this.progressBar.setMaximum(this.maxRow);
            }
            this.progressBar.setValue(this.currentRow);
        }
    }
}

