/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jfree.report.modules.gui.config.BugFixProxyGraphics2D;
import org.jfree.report.modules.gui.config.model.ConfigTreeModuleNode;
import org.jfree.report.modules.gui.config.model.ConfigTreeRootNode;
import org.jfree.report.modules.gui.config.model.ConfigTreeSectionNode;

public class ConfigTreeRenderer
extends DefaultTreeCellRenderer {
    public ConfigTreeRenderer() {
        this.setDoubleBuffered(false);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof ConfigTreeRootNode) {
            return super.getTreeCellRendererComponent(tree, "<Root>", sel, expanded, leaf, row, hasFocus);
        }
        if (value instanceof ConfigTreeSectionNode) {
            ConfigTreeSectionNode node = (ConfigTreeSectionNode)value;
            return super.getTreeCellRendererComponent(tree, node.getName(), sel, expanded, leaf, row, hasFocus);
        }
        if (value instanceof ConfigTreeModuleNode) {
            ConfigTreeModuleNode node = (ConfigTreeModuleNode)value;
            StringBuffer text = new StringBuffer();
            text.append(node.getModule().getName());
            text.append(" - ");
            text.append(node.getModule().getMajorVersion());
            text.append(".");
            text.append(node.getModule().getMinorVersion());
            text.append("-");
            text.append(node.getModule().getPatchLevel());
            return super.getTreeCellRendererComponent(tree, text.toString(), sel, expanded, leaf, row, hasFocus);
        }
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public void paint(Graphics g) {
        super.paint(new BugFixProxyGraphics2D((Graphics2D)g));
    }
}

