/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config.model;

import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.ConfigTreeModelException;
import org.jfree.report.modules.gui.config.model.ConfigTreeNode;
import org.jfree.report.modules.gui.config.model.ConfigTreeRootNode;
import org.jfree.report.modules.gui.config.model.ConfigTreeSectionNode;
import org.jfree.report.modules.gui.config.model.ModuleNodeFactory;

public class ConfigTreeModel
implements TreeModel {
    private final ConfigTreeRootNode root = new ConfigTreeRootNode("<root>");
    private final ConfigTreeSectionNode globalSection = new ConfigTreeSectionNode("Global configuration");
    private final ConfigTreeSectionNode localSection = new ConfigTreeSectionNode("Local configuration");
    private ModuleNodeFactory nodeFactory;
    private final ArrayList listeners = new ArrayList();

    public ConfigTreeModel(InputStream specs) throws ConfigTreeModelException {
        this.root.add(this.globalSection);
        this.root.add(this.localSection);
        try {
            this.nodeFactory = new ModuleNodeFactory(specs);
        }
        catch (Exception ioe) {
            throw new ConfigTreeModelException("Failed to initialize the model.", ioe);
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.listeners.add(l);
    }

    private void fireTreeModelChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            TreeModelListener l = (TreeModelListener)this.listeners.get(i);
            l.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.root)));
            ++i;
        }
    }

    public Object getChild(Object parent, int index) {
        TreeNode node = (TreeNode)parent;
        return node.getChildAt(index);
    }

    public int getChildCount(Object parent) {
        TreeNode node = (TreeNode)parent;
        return node.getChildCount();
    }

    public ConfigDescriptionEntry getEntryForKey(String key) {
        return this.nodeFactory.getEntryForKey(key);
    }

    public int getIndexOfChild(Object parent, Object child) {
        TreeNode node = (TreeNode)parent;
        TreeNode childNode = (TreeNode)child;
        return node.getIndex(childNode);
    }

    public Object getRoot() {
        return this.root;
    }

    public void init(HierarchicalConfiguration config) throws ConfigTreeModelException {
        this.globalSection.reset();
        this.localSection.reset();
        this.nodeFactory.init(config);
        ArrayList list = this.nodeFactory.getGlobalNodes();
        int i = 0;
        while (i < list.size()) {
            this.globalSection.add((ConfigTreeNode)list.get(i));
            ++i;
        }
        list = this.nodeFactory.getLocalNodes();
        int i2 = 0;
        while (i2 < list.size()) {
            this.localSection.add((ConfigTreeNode)list.get(i2));
            ++i2;
        }
        this.fireTreeModelChanged();
    }

    public boolean isLeaf(Object node) {
        TreeNode tnode = (TreeNode)node;
        return tnode.isLeaf();
    }

    public void removeTreeModelListener(TreeModelListener l) {
        ((AbstractCollection)this.listeners).remove(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

