/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.plaintext;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jfree.report.modules.gui.base.components.EncodingComboBoxModel;
import org.jfree.report.modules.output.pageable.plaintext.PrinterEncoding;
import org.jfree.report.modules.output.pageable.plaintext.PrinterSpecification;
import org.jfree.report.util.EncodingSupport;

public class EncodingSelector
extends JPanel {
    private EncodingComboBoxModel encodingComboBoxModel;
    private JComboBox encodingComboBox;

    public EncodingSelector() {
        this.setLayout(new BorderLayout());
        this.encodingComboBox = new JComboBox();
        this.add((Component)this.encodingComboBox, "Center");
        this.setEncodings(new GenericPrinterSpecification());
    }

    public String getSelectedEncoding() {
        return this.encodingComboBoxModel.getSelectedEncoding();
    }

    public void setEncodings(PrinterSpecification printerSpecification) {
        if (printerSpecification == null) {
            throw new NullPointerException("Specification must not be null.");
        }
        EncodingComboBoxModel defaultEncodingModel = EncodingComboBoxModel.createDefaultModel();
        EncodingComboBoxModel retval = new EncodingComboBoxModel();
        int i = 0;
        while (i < defaultEncodingModel.getSize()) {
            String encoding = defaultEncodingModel.getEncoding(i);
            if (printerSpecification.isEncodingSupported(encoding)) {
                String description = defaultEncodingModel.getDescription(i);
                retval.addEncoding(encoding, description);
            }
            ++i;
        }
        retval.sort();
        Object oldSelectedValue = this.encodingComboBox.getSelectedItem();
        this.encodingComboBox.setModel(retval);
        this.encodingComboBoxModel = retval;
        this.encodingComboBoxModel.setSelectedItem(oldSelectedValue);
    }

    public void setSelectedEncoding(String encoding) {
        this.encodingComboBoxModel.setSelectedEncoding(encoding);
    }

    public static class GenericPrinterSpecification
    implements PrinterSpecification {
        public String getDisplayName() {
            return this.getName();
        }

        public PrinterEncoding getEncoding(String encoding) {
            if (!this.isEncodingSupported(encoding)) {
                throw new IllegalArgumentException("Encoding is not supported.");
            }
            return new PrinterEncoding(encoding, encoding, encoding, new byte[0]);
        }

        public String getName() {
            return "Generic Printer";
        }

        public boolean isEncodingSupported(String encoding) {
            return EncodingSupport.isSupportedEncoding(encoding);
        }

        public boolean isFeatureAvailable(String operationName) {
            return true;
        }
    }
}

