/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.rtf;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.base.AbstractExportPlugin;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.gui.rtf.RTFExportDialog;
import org.jfree.report.modules.gui.rtf.RTFExportTask;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.ResourceBundleSupport;

public class RTFExportPlugin
extends AbstractExportPlugin {
    private RTFExportDialog exportDialog;
    private final ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.rtf.resources.rtf-export-resources");
    public static final String BASE_RESOURCE_CLASS = "org.jfree.report.modules.gui.rtf.resources.rtf-export-resources";
    public static final String PROGRESS_DIALOG_ENABLE_KEY = "org.jfree.report.modules.gui.rtf.ProgressDialogEnabled";

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setTitle(this.resources.getString("rtf-export.progressdialog.title"));
        progressDialog.setMessage(this.resources.getString("rtf-export.progressdialog.message"));
        progressDialog.pack();
        RefineryUtilities.positionFrameRandomly((Window)progressDialog);
        return progressDialog;
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getKeyStroke("action.export-to-rtf.accelerator");
    }

    public String getDisplayName() {
        return this.resources.getString("action.export-to-rtf.name");
    }

    protected RTFExportDialog getExportDialog() {
        if (this.exportDialog == null) {
            PreviewProxy proxy = super.getProxy();
            this.exportDialog = proxy instanceof Frame ? new RTFExportDialog((Frame)((Object)proxy)) : (proxy instanceof Dialog ? new RTFExportDialog((Dialog)((Object)proxy)) : new RTFExportDialog());
            this.exportDialog.pack();
        }
        return this.exportDialog;
    }

    public Icon getLargeIcon() {
        return this.resources.getIcon("action.export-to-rtf.icon");
    }

    public Integer getMnemonicKey() {
        return this.resources.getMnemonic("action.export-to-rtf.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    public String getShortDescription() {
        return this.resources.getString("action.export-to-rtf.description");
    }

    public Icon getSmallIcon() {
        return this.resources.getIcon("action.export-to-rtf.small-icon");
    }

    public boolean isAddToToolbar() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.rtf.AddToToolbar", "false").equals("true");
    }

    public boolean isSeparated() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.rtf.Separated", "false").equals("true");
    }

    public boolean performExport(JFreeReport report) {
        RTFExportDialog exportDialog = this.getExportDialog();
        boolean result = exportDialog.performQueryForExport(report);
        if (!result) {
            return this.handleExportResult(true);
        }
        ReportProgressDialog progressDialog = report.getReportConfiguration().getConfigProperty(PROGRESS_DIALOG_ENABLE_KEY, "false").equals("true") ? this.createProgressDialog() : null;
        RTFExportTask task = new RTFExportTask(exportDialog.getFilename(), progressDialog, report);
        task.addExportTaskListener(new AbstractExportPlugin.DefaultExportTaskListener());
        this.delegateTask(task);
        return this.handleExportResult(task);
    }
}

