/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class JoiningTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private Class[] columnTypes;
    private ArrayList models = new ArrayList();
    private TableChangeHandler changeHandler = new TableChangeHandler();
    private int rowCount;
    public static final String TABLE_PREFIX_COLUMN = "TablePrefix";
    static /* synthetic */ Class class$java$lang$String;

    public synchronized void addTableModel(String prefix, TableModel model) {
        this.models.add(new TablePosition(model, prefix));
        model.addTableModelListener(this.changeHandler);
        this.updateStructure();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public synchronized Class getColumnClass(int columnIndex) {
        return this.columnTypes[columnIndex];
    }

    public synchronized int getColumnCount() {
        return this.columnNames.length;
    }

    public synchronized String getColumnName(int column) {
        return this.columnNames[column];
    }

    public synchronized int getRowCount() {
        return this.rowCount;
    }

    public synchronized TableModel getTableModel(int pos) {
        TablePosition position = (TablePosition)this.models.get(pos);
        return position.getTableModel();
    }

    public synchronized int getTableModelCount() {
        return this.models.size();
    }

    private TablePosition getTableModelForRow(int row) {
        int i = 0;
        while (i < this.models.size()) {
            TablePosition pos = (TablePosition)this.models.get(i);
            int maxRow = pos.getTableOffset() + pos.getTableModel().getRowCount();
            if (row < maxRow) {
                return pos;
            }
            ++i;
        }
        return null;
    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        TablePosition pos = this.getTableModelForRow(rowIndex);
        if (pos == null) {
            return null;
        }
        if (columnIndex == 0) {
            return pos.getPrefix();
        }
        int columnOffset = pos.getColumnOffset();
        if (columnIndex < columnOffset) {
            return null;
        }
        TableModel tableModel = pos.getTableModel();
        if (columnIndex >= columnOffset + tableModel.getColumnCount()) {
            return null;
        }
        return tableModel.getValueAt(rowIndex - pos.getTableOffset(), columnIndex - columnOffset);
    }

    public final boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public synchronized void removeTableModel(TableModel model) {
        int i = 0;
        while (i < this.models.size()) {
            TablePosition position = (TablePosition)this.models.get(i);
            if (position.getTableModel() == model) {
                ((AbstractCollection)this.models).remove(model);
                model.removeTableModelListener(this.changeHandler);
                this.updateStructure();
                return;
            }
            ++i;
        }
    }

    protected void updateData() {
        this.fireTableDataChanged();
    }

    protected synchronized void updateRowCount() {
        int rowOffset = 0;
        int columnOffset = 1;
        int i = 0;
        while (i < this.models.size()) {
            TablePosition model = (TablePosition)this.models.get(i);
            model.updateOffsets(rowOffset, columnOffset);
            rowOffset += model.getTableModel().getRowCount();
            columnOffset += model.getTableModel().getColumnCount();
            ++i;
        }
        this.fireTableStructureChanged();
    }

    protected synchronized void updateStructure() {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList columnTypes = new ArrayList();
        int rowOffset = 0;
        int columnOffset = 1;
        columnNames.add(TABLE_PREFIX_COLUMN);
        columnTypes.add(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JoiningTableModel.class$("java.lang.String")));
        int i = 0;
        while (i < this.models.size()) {
            TablePosition pos = (TablePosition)this.models.get(i);
            pos.updateOffsets(rowOffset, columnOffset);
            TableModel tableModel = pos.getTableModel();
            rowOffset += tableModel.getRowCount();
            columnOffset += tableModel.getColumnCount();
            int c = 0;
            while (c < tableModel.getColumnCount()) {
                columnNames.add(String.valueOf(pos.getPrefix()) + "." + tableModel.getColumnName(c));
                columnTypes.add(tableModel.getColumnClass(c));
                ++c;
            }
            ++i;
        }
        this.columnNames = columnNames.toArray(new String[columnNames.size()]);
        this.columnTypes = columnTypes.toArray(new Class[columnTypes.size()]);
        this.rowCount = rowOffset;
        this.fireTableStructureChanged();
    }

    private static class TablePosition {
        private TableModel tableModel;
        private String prefix;
        private int tableOffset;
        private int columnOffset;

        public TablePosition(TableModel tableModel, String prefix) {
            if (tableModel == null) {
                throw new NullPointerException("Model must not be null");
            }
            if (prefix == null) {
                throw new NullPointerException("Prefix must not be null.");
            }
            this.tableModel = tableModel;
            this.prefix = prefix;
        }

        public int getColumnOffset() {
            return this.columnOffset;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public TableModel getTableModel() {
            return this.tableModel;
        }

        public int getTableOffset() {
            return this.tableOffset;
        }

        public void updateOffsets(int tableOffset, int columnOffset) {
            this.tableOffset = tableOffset;
            this.columnOffset = columnOffset;
        }
    }

    private class TableChangeHandler
    implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == -1) {
                JoiningTableModel.this.updateStructure();
            } else if (e.getType() == 1 || e.getType() == -1) {
                JoiningTableModel.this.updateRowCount();
            } else {
                JoiningTableModel.this.updateData();
            }
        }
    }
}

