/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.swing.table.AbstractTableModel;
import org.jfree.report.modules.misc.tablemodel.TypeMapper;
import org.jfree.report.util.CloseableTableModel;
import org.jfree.util.Log;

public class ScrollableResultSetTableModel
extends AbstractTableModel
implements CloseableTableModel {
    private ResultSet resultset;
    private ResultSetMetaData dbmd;
    private int rowCount;
    private final boolean labelMapMode;
    private Class[] types;
    static /* synthetic */ Class class$java$lang$Object;

    public ScrollableResultSetTableModel(ResultSet resultset, boolean labelMapMode) throws SQLException {
        this.labelMapMode = labelMapMode;
        if (resultset != null) {
            this.updateResultSet(resultset);
        } else {
            this.close();
        }
    }

    protected ScrollableResultSetTableModel(boolean labelMapMode) {
        this.labelMapMode = labelMapMode;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() {
        if (this.resultset != null) {
            try {
                this.resultset.close();
            }
            catch (SQLException sQLException) {}
        }
        this.resultset = null;
        this.dbmd = null;
        this.rowCount = 0;
        this.fireTableStructureChanged();
    }

    public Class getColumnClass(int column) {
        if (this.types != null) {
            return this.types[column];
        }
        if (this.dbmd != null) {
            try {
                this.types = TypeMapper.mapTypes(this.dbmd);
                return this.types[column];
            }
            catch (Exception exception) {}
        }
        return class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ScrollableResultSetTableModel.class$("java.lang.Object"));
    }

    public String getColumnClassName(int column) {
        if (this.dbmd != null) {
            return this.mckoiDBFixClassName(this.getColumnClass(column).getName());
        }
        return (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ScrollableResultSetTableModel.class$("java.lang.Object"))).getName();
    }

    public int getColumnCount() {
        if (this.resultset == null) {
            return 0;
        }
        if (this.dbmd != null) {
            try {
                return this.dbmd.getColumnCount();
            }
            catch (SQLException sQLException) {
            }
        }
        return 0;
    }

    public String getColumnName(int column) {
        if (this.dbmd != null) {
            try {
                if (this.isLabelMapMode()) {
                    return this.dbmd.getColumnLabel(column + 1);
                }
                return this.dbmd.getColumnName(column + 1);
            }
            catch (SQLException sQLException) {
                Log.info((Object)"ScrollableResultSetTableModel.getColumnName: SQLException.");
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.resultset == null) {
            return 0;
        }
        try {
            if (this.resultset.last()) {
                this.rowCount = this.resultset.getRow();
                if (this.rowCount == -1) {
                    this.rowCount = 0;
                }
            } else {
                this.rowCount = 0;
            }
        }
        catch (SQLException sQLException) {
            return 0;
        }
        return this.rowCount;
    }

    public Object getValueAt(int row, int column) {
        if (this.resultset != null) {
            try {
                this.resultset.absolute(row + 1);
                return this.resultset.getObject(column + 1);
            }
            catch (SQLException sQLException) {
            }
        }
        return null;
    }

    public boolean isLabelMapMode() {
        return this.labelMapMode;
    }

    private String mckoiDBFixClassName(String classname) {
        if (classname.startsWith("class ")) {
            return classname.substring(6).trim();
        }
        return classname;
    }

    public void updateResultSet(ResultSet resultset) throws SQLException {
        if (this.resultset != null) {
            this.close();
        }
        this.resultset = resultset;
        this.dbmd = resultset.getMetaData();
        this.rowCount = resultset.last() ? resultset.getRow() : 0;
        this.fireTableStructureChanged();
    }
}

