/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SubSetTableModel
implements TableModel {
    private int start;
    private int end;
    private TableModel model;
    private TableEventTranslator eventHandler;

    public SubSetTableModel(int start, int end, TableModel model) {
        if (start < 0) {
            throw new IllegalArgumentException("Start < 0");
        }
        if (end <= start) {
            throw new IllegalArgumentException("end < start");
        }
        if (model == null) {
            throw new NullPointerException();
        }
        if (end >= model.getRowCount()) {
            throw new IllegalArgumentException("End >= Model.RowCount");
        }
        this.start = start;
        this.end = end;
        this.model = model;
        class Org_jfree_report_modules_misc_tablemodel_SubSetTableModel$1 {
            /* synthetic */ Org_jfree_report_modules_misc_tablemodel_SubSetTableModel$1() {
            }
        }
        this.eventHandler = new TableEventTranslator();
    }

    public void addTableModelListener(TableModelListener l) {
        this.eventHandler.addTableModelListener(l);
    }

    private int getClientRowIndex(int rowIndex) {
        return rowIndex + this.start;
    }

    public Class getColumnClass(int columnIndex) {
        return this.model.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String getColumnName(int columnIndex) {
        return this.model.getColumnName(columnIndex);
    }

    protected TableModel getEnclosedModel() {
        return this.model;
    }

    protected int getEnd() {
        return this.end;
    }

    public int getRowCount() {
        int rowCount = this.model.getRowCount();
        return rowCount - this.start - (rowCount - this.end);
    }

    protected int getStart() {
        return this.start;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.getValueAt(this.getClientRowIndex(rowIndex), columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.model.isCellEditable(this.getClientRowIndex(rowIndex), columnIndex);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.eventHandler.removeTableModelListener(l);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.model.setValueAt(aValue, this.getClientRowIndex(rowIndex), columnIndex);
    }

    private final class TableEventTranslator
    implements TableModelListener {
        private final ArrayList listeners = new ArrayList();

        private TableEventTranslator() {
        }

        protected void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        protected void removeTableModelListener(TableModelListener l) {
            ((AbstractCollection)this.listeners).remove(l);
        }

        public void tableChanged(TableModelEvent e) {
            int lastRow;
            int firstRow = e.getFirstRow();
            if (e.getFirstRow() > 0) {
                firstRow -= SubSetTableModel.this.getStart();
            }
            if ((lastRow = e.getLastRow()) > 0) {
                lastRow -= SubSetTableModel.this.getStart();
                lastRow -= SubSetTableModel.this.getEnclosedModel().getRowCount() - SubSetTableModel.this.getEnd();
            }
            int type = e.getType();
            int column = e.getColumn();
            TableModelEvent event = new TableModelEvent(SubSetTableModel.this, firstRow, lastRow, column, type);
            int i = 0;
            while (i < this.listeners.size()) {
                TableModelListener l = (TableModelListener)this.listeners.get(i);
                l.tableChanged(event);
                ++i;
            }
        }
    }
}

