/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.base.output;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.jfree.report.PageDefinition;
import org.jfree.report.ShapeElement;
import org.jfree.report.content.AnchorContentFactoryModule;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentFactory;
import org.jfree.report.content.ContentType;
import org.jfree.report.content.DefaultContentFactory;
import org.jfree.report.content.DrawableContent;
import org.jfree.report.content.DrawableContentFactoryModule;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.content.ImageContent;
import org.jfree.report.content.ImageContentFactoryModule;
import org.jfree.report.content.MultipartContent;
import org.jfree.report.content.ShapeContent;
import org.jfree.report.content.ShapeContentFactoryModule;
import org.jfree.report.content.ShapeTransform;
import org.jfree.report.content.TextContentFactoryModule;
import org.jfree.report.content.TextLine;
import org.jfree.report.layout.LayoutManagerCache;
import org.jfree.report.layout.SizeCalculator;
import org.jfree.report.layout.SizeCalculatorException;
import org.jfree.report.modules.output.meta.MetaBand;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.meta.MetaPage;
import org.jfree.report.modules.output.pageable.base.OutputTarget;
import org.jfree.report.modules.output.pageable.base.OutputTargetException;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public strictfp abstract class AbstractOutputTarget
implements OutputTarget {
    private final Properties properties = new Properties();
    private final ContentFactory contentFactory = this.createContentFactory();
    private StrictBounds operationBounds = new StrictBounds();
    private StrictBounds pageBounds = new StrictBounds();
    private LayoutManagerCache cache = new LayoutManagerCache();

    protected AbstractOutputTarget() {
    }

    protected abstract void beginPage(PageDefinition var1, int var2) throws OutputTargetException;

    public abstract void close();

    public abstract void configure(Configuration var1);

    protected ContentFactory createContentFactory() {
        DefaultContentFactory contentFactory = new DefaultContentFactory();
        contentFactory.addModule(new TextContentFactoryModule());
        contentFactory.addModule(new ImageContentFactoryModule());
        contentFactory.addModule(new ShapeContentFactoryModule());
        contentFactory.addModule(new DrawableContentFactoryModule());
        contentFactory.addModule(new AnchorContentFactoryModule());
        return contentFactory;
    }

    public abstract SizeCalculator createTextSizeCalculator(FontDefinition var1) throws SizeCalculatorException;

    protected abstract void drawDrawable(DrawableContent var1) throws OutputTargetException;

    protected abstract void drawImage(ImageContent var1) throws OutputTargetException;

    protected abstract void drawShape(Shape var1);

    protected abstract void endPage() throws OutputTargetException;

    protected abstract void fillShape(Shape var1);

    public LayoutManagerCache getCache() {
        return this.cache;
    }

    public ContentFactory getContentFactory() {
        return this.contentFactory;
    }

    protected abstract FontDefinition getFont();

    public float getHorizontalAlignmentBorder() {
        return 0.0f;
    }

    public long getInternalHorizontalAlignmentBorder() {
        return 0L;
    }

    protected StrictBounds getInternalOperationBounds() {
        return this.operationBounds;
    }

    protected StrictBounds getInternalPageBounds() {
        return this.pageBounds;
    }

    public long getInternalVerticalAlignmentBorder() {
        return 0L;
    }

    protected Rectangle2D getOperationBounds() {
        return StrictGeomUtility.createAWTRectangle(this.operationBounds.getX(), this.operationBounds.getY(), this.operationBounds.getWidth(), this.operationBounds.getHeight());
    }

    protected Rectangle2D getPageBounds() {
        return StrictGeomUtility.createAWTRectangle(this.pageBounds.getX(), this.pageBounds.getY(), this.pageBounds.getWidth(), this.pageBounds.getHeight());
    }

    protected abstract Paint getPaint();

    public String getProperty(String property) {
        return this.getProperty(property, null);
    }

    public String getProperty(String property, String defaultValue) {
        if (property == null) {
            throw new NullPointerException();
        }
        String retval = this.properties.getProperty(property);
        if (retval == null) {
            return defaultValue;
        }
        return retval;
    }

    protected Iterator getPropertyNames() {
        return ((Hashtable)this.properties).keySet().iterator();
    }

    protected abstract Stroke getStroke();

    public float getVerticalAlignmentBorder() {
        return 0.0f;
    }

    public abstract boolean isOpen();

    protected abstract boolean isPaintSupported(Paint var1);

    public abstract void open() throws OutputTargetException;

    protected void printAnchorContent(MetaElement element, Content content) throws OutputTargetException {
    }

    protected void printBand(MetaBand band, StrictBounds bounds) throws OutputTargetException {
        this.printElement(band, bounds);
        MetaElement[] elements = band.toArray();
        int i = 0;
        while (i < elements.length) {
            MetaElement e = elements[i];
            StrictBounds elementBounds = e.getBounds();
            if (StrictBounds.intersects(bounds, elementBounds)) {
                if (e instanceof MetaBand) {
                    this.printBand((MetaBand)e, bounds.createIntersection(elementBounds));
                } else {
                    this.printElement(e, bounds.createIntersection(elementBounds));
                }
            }
            ++i;
        }
    }

    protected void printContainerContent(MetaElement element, Content content) throws OutputTargetException {
    }

    protected void printContent(MetaElement element, Content content) throws OutputTargetException {
        if (content.getContentType().equals(ContentType.TEXT)) {
            this.printTextContent(element, content);
        } else if (element.getContent().getContentType().equals(ContentType.SHAPE)) {
            this.printShapeContent(element, content);
        } else if (element.getContent().getContentType().equals(ContentType.IMAGE)) {
            this.printImageContent(element, content);
        } else if (element.getContent().getContentType().equals(ContentType.DRAWABLE)) {
            this.printDrawableContent(element, content);
        } else if (element.getContent().getContentType().equals(ContentType.CONTAINER)) {
            this.printContainerContent(element, content);
        } else if (element.getContent().getContentType().equals(ContentType.ANCHOR)) {
            this.printAnchorContent(element, content);
        } else {
            Log.warn((Object)"Unknown content");
        }
        if (content instanceof MultipartContent) {
            MultipartContent mc = (MultipartContent)content;
            int i = 0;
            while (i < mc.getContentPartCount()) {
                this.printContent(element, mc.getContentPart(i));
                ++i;
            }
        }
    }

    protected void printDrawableContent(MetaElement element, Content content) throws OutputTargetException {
        if (!(content instanceof DrawableContent)) {
            return;
        }
        DrawableContent drawableContent = (DrawableContent)content;
        this.setInternalOperationBounds(content.getBounds());
        String hrefTarget = (String)element.getProperty(ElementStyleSheet.HREF_TARGET);
        if (hrefTarget != null) {
            this.printHRefForCurrentContent(hrefTarget);
        }
        this.drawDrawable(drawableContent);
    }

    protected void printElement(MetaElement element, StrictBounds bounds) throws OutputTargetException {
        Content content;
        String hrefTarget = (String)element.getProperty(ElementStyleSheet.HREF_TARGET);
        if (hrefTarget != null) {
            this.printHRefTarget(element, hrefTarget);
        }
        if ((content = element.getContent().getContentForBounds(bounds)) instanceof EmptyContent) {
            return;
        }
        this.printContent(element, content);
    }

    protected void printHRefForCurrentContent(String href) {
    }

    protected void printHRefTarget(MetaElement element, String target) {
    }

    protected void printImageContent(MetaElement element, Content content) throws OutputTargetException {
        if (!(content instanceof ImageContent)) {
            return;
        }
        ImageContent ic = (ImageContent)content;
        this.setInternalOperationBounds(content.getBounds());
        String hrefTarget = (String)element.getProperty(ElementStyleSheet.HREF_TARGET);
        if (hrefTarget != null) {
            this.printHRefForCurrentContent(hrefTarget);
        }
        this.drawImage(ic);
    }

    public void printPage(MetaPage content, PageDefinition page, int index) throws OutputTargetException {
        this.setPageBounds(page.getPagePosition(index));
        this.beginPage(page, index);
        StrictBounds pageBounds = this.getInternalPageBounds();
        MetaBand[] bands = content.getBands();
        int i = 0;
        while (i < bands.length) {
            MetaBand b = bands[i];
            StrictBounds bounds = b.getBounds();
            if (StrictBounds.intersects(bounds, pageBounds)) {
                this.printBand(b, pageBounds.createIntersection(bounds));
            }
            ++i;
        }
        this.endPage();
    }

    protected void printShapeContent(MetaElement element, Content content) throws OutputTargetException {
        if (!(content instanceof ShapeContent)) {
            return;
        }
        boolean shouldDraw = element.getBooleanProperty(ShapeElement.DRAW_SHAPE);
        boolean shouldFill = element.getBooleanProperty(ShapeElement.FILL_SHAPE);
        if (!shouldFill && !shouldDraw) {
            return;
        }
        this.setInternalOperationBounds(content.getBounds());
        Stroke stroke = (Stroke)element.getProperty(ElementStyleSheet.STROKE);
        this.updateStroke(stroke);
        Paint extpaint = (Paint)element.getProperty(ElementStyleSheet.EXTPAINT);
        if (extpaint != null && this.isPaintSupported(extpaint)) {
            this.updatePaint(extpaint);
        } else {
            Color paint = (Color)element.getProperty(ElementStyleSheet.PAINT);
            this.updatePaint(paint);
        }
        String hrefTarget = (String)element.getProperty(ElementStyleSheet.HREF_TARGET);
        if (hrefTarget != null) {
            this.printHRefForCurrentContent(hrefTarget);
        }
        ShapeContent sc = (ShapeContent)content;
        Rectangle2D clipBounds = this.getOperationBounds();
        Shape s = ShapeTransform.performCliping(sc.getShape(), clipBounds);
        if (shouldDraw) {
            this.drawShape(s);
        }
        if (shouldFill) {
            this.fillShape(s);
        }
    }

    protected abstract void printText(String var1);

    protected void printTextContent(MetaElement element, Content content) throws OutputTargetException {
        if (element == null) {
            throw new NullPointerException("element is null");
        }
        if (!(content instanceof TextLine)) {
            return;
        }
        FontDefinition font = element.getFontDefinitionProperty();
        this.updateFont(font);
        Paint extpaint = (Paint)element.getProperty(ElementStyleSheet.EXTPAINT);
        if (extpaint != null && this.isPaintSupported(extpaint)) {
            this.updatePaint(extpaint);
        } else {
            Color paint = (Color)element.getProperty(ElementStyleSheet.PAINT);
            this.updatePaint(paint);
        }
        Stroke stroke = (Stroke)element.getProperty(ElementStyleSheet.STROKE);
        this.updateStroke(stroke);
        String hrefTarget = (String)element.getProperty(ElementStyleSheet.HREF_TARGET);
        this.printTextLine((TextLine)content, hrefTarget);
    }

    protected void printTextLine(TextLine c, String hrefTarget) {
        String value = c.getContent();
        this.setInternalOperationBounds(c.getBounds());
        if (hrefTarget != null) {
            this.printHRefForCurrentContent(hrefTarget);
        }
        this.printText(value);
    }

    protected abstract void setFont(FontDefinition var1) throws OutputTargetException;

    protected void setInternalOperationBounds(StrictBounds operationBounds) {
        this.operationBounds.setRect(operationBounds.getX(), operationBounds.getY(), operationBounds.getWidth(), operationBounds.getHeight());
    }

    protected void setPageBounds(Rectangle2D pageBounds) {
        long x = StrictGeomUtility.toInternalValue(pageBounds.getX());
        long y = StrictGeomUtility.toInternalValue(pageBounds.getY());
        long w = StrictGeomUtility.toInternalValue(pageBounds.getWidth());
        long h = StrictGeomUtility.toInternalValue(pageBounds.getHeight());
        this.pageBounds.setRect(x, y, w, h);
    }

    protected abstract void setPaint(Paint var1);

    public void setProperty(String property, String value) {
        if (property == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            ((Hashtable)this.properties).remove(property);
        } else {
            this.properties.setProperty(property, value);
        }
    }

    protected abstract void setStroke(Stroke var1) throws OutputTargetException;

    protected void updateFont(FontDefinition f) throws OutputTargetException {
        if (f == null) {
            throw new NullPointerException("Font must not be null.");
        }
        if (!f.equals(this.getFont())) {
            this.setFont(f);
        }
    }

    protected void updatePaint(Paint paint) {
        if (!paint.equals(this.getPaint())) {
            this.setPaint(paint);
        }
    }

    protected void updateStroke(Stroke stroke) throws OutputTargetException {
        if (stroke == null) {
            throw new NullPointerException("Stroke must not be null.");
        }
        if (!stroke.equals(this.getStroke())) {
            this.setStroke(stroke);
        }
    }
}

